/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.googlemaps.AbstractGoogleMapsDemo;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMap;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapMarker;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapPoint;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapPolygon;
import com.flowingcode.vaadin.addons.googlemaps.GooglemapsDemoView;
import com.flowingcode.vaadin.addons.googlemaps.IconSequence;
import com.flowingcode.vaadin.addons.googlemaps.LatLon;
import com.flowingcode.vaadin.addons.googlemaps.Symbol;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.Arrays;

@PageTitle(value="Google Maps Demo")
@DemoSource
@Route(value="googlemaps/googlemaps", layout=GooglemapsDemoView.class)
public class GoogleMapsDemo
extends AbstractGoogleMapsDemo {
    @Override
    protected void createGoogleMapsDemo(String apiKey) {
        GoogleMap gmaps = new GoogleMap(apiKey, null, null);
        gmaps.setMapType(GoogleMap.MapType.SATELLITE);
        gmaps.setSizeFull();
        gmaps.setCenter(new LatLon(-31.636036, -60.7055271));
        gmaps.addClickListener((ComponentEventListener & Serializable)ev -> Notification.show((String)("Left click at latitude: " + ev.getLatitude() + "; Longitude: " + ev.getLongitude())));
        gmaps.addRightClickListener((ComponentEventListener & Serializable)ev -> Notification.show((String)("Right click at latitude: " + ev.getLatitude() + "; Longitude: " + ev.getLongitude())));
        GoogleMapMarker flowingmarker = gmaps.addMarker("Center", gmaps.getCenter(), false, "https://www.flowingcode.com/wp-content/uploads/2020/06/FCMarker.png");
        flowingmarker.addInfoWindow("<h1>Flowing Code</h1>");
        GoogleMapPolygon gmp = gmaps.addPolygon(Arrays.asList(new GoogleMapPoint(Double.valueOf(gmaps.getCenter().getLat()), Double.valueOf(gmaps.getCenter().getLon() + 1.0)), new GoogleMapPoint(Double.valueOf(gmaps.getCenter().getLat() + 1.0), Double.valueOf(gmaps.getCenter().getLon())), new GoogleMapPoint(Double.valueOf(gmaps.getCenter().getLat()), Double.valueOf(gmaps.getCenter().getLon() - 1.0)), new GoogleMapPoint(Double.valueOf(gmaps.getCenter().getLat() - 1.0), Double.valueOf(gmaps.getCenter().getLon())), new GoogleMapPoint(Double.valueOf(gmaps.getCenter().getLat()), Double.valueOf(gmaps.getCenter().getLon() + 1.0))));
        gmp.setClosed(false);
        gmp.setIcons(new IconSequence[]{new IconSequence(new Symbol("M -2,0 0,-2 2,0 0,2 z", "#F00", "#FF0", Double.valueOf(1.0)), "25px")});
        gmp.addClickListener((ComponentEventListener & Serializable)e -> Notification.show((String)"Polygon clicked"));
        Button center = new Button("Show Coordinates", (ComponentEventListener & Serializable)ev -> Notification.show((String)("Center coordinates: " + gmaps.getCenter())));
        Button toggleInfoWindow = new Button("Toggle Info Window", (ComponentEventListener & Serializable)ev -> flowingmarker.setInfoWindowVisible(!flowingmarker.isInfoWindowVisible()));
        FlexLayout layout = new FlexLayout();
        layout.setFlexWrap(FlexLayout.FlexWrap.WRAP);
        center.addClassName("margin-button");
        toggleInfoWindow.addClassName("margin-button");
        layout.add(new Component[]{center, toggleInfoWindow});
        this.add(new Component[]{gmaps, layout});
    }
}

