/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.googlemaps;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.googlemaps.AbstractGoogleMapsDemo;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMap;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapIcon;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapMarker;
import com.flowingcode.vaadin.addons.googlemaps.GoogleMapPoint;
import com.flowingcode.vaadin.addons.googlemaps.GooglemapsDemoView;
import com.flowingcode.vaadin.addons.googlemaps.LatLon;
import com.flowingcode.vaadin.addons.googlemaps.MarkerIcon;
import com.flowingcode.vaadin.addons.googlemaps.Symbol;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;

@PageTitle(value="Customized Marker Icons Demo")
@DemoSource
@Route(value="googlemaps/markericons", layout=GooglemapsDemoView.class)
public class CustomizedMarkerIconsDemo
extends AbstractGoogleMapsDemo {
    @Override
    protected void createGoogleMapsDemo(String apiKey) {
        GoogleMap gmaps = new GoogleMap(apiKey, null, null);
        gmaps.setMapType(GoogleMap.MapType.ROADMAP);
        gmaps.setSizeFull();
        gmaps.setCenter(new LatLon(-31.635175, -60.698405));
        gmaps.setZoom(16);
        gmaps.addMarker("Marker with only an URL as icon", gmaps.getCenter(), false, "https://www.flowingcode.com/wp-content/uploads/2020/06/FCMarker.png");
        MarkerIcon markerIcon = new MarkerIcon("http://maps.google.com/mapfiles/ms/micons/green.png");
        markerIcon.setAnchor(new GoogleMapPoint(Double.valueOf(15.0), Double.valueOf(10.0)));
        gmaps.addMarker(new GoogleMapMarker("Marker with MarkerIcon defining url and anchor points", new LatLon(-31.636027, -60.703253), false, (GoogleMapIcon)markerIcon));
        Symbol symbol = new Symbol("M-1.547 12l6.563-6.609-1.406-1.406-5.156 5.203-2.063-2.109-1.406 1.406zM0 0q2.906 0 4.945 2.039t2.039 4.945q0 1.453-0.727 3.328t-1.758 3.516-2.039 3.070-1.711 2.273l-0.75 0.797q-0.281-0.328-0.75-0.867t-1.688-2.156-2.133-3.141-1.664-3.445-0.75-3.375q0-2.906 2.039-4.945t4.945-2.039z");
        symbol.setFillColor("purple");
        symbol.setFillOpacity(Double.valueOf(1.0));
        symbol.setAnchor(new GoogleMapPoint(Double.valueOf(20.0), Double.valueOf(-0.5)));
        symbol.setRotation(Double.valueOf(180.0));
        symbol.setScale(Double.valueOf(1.5));
        gmaps.addMarker(new GoogleMapMarker("Marker with Symbol defining path, anchor points, rotation, scale, fill color and fill opacity", new LatLon(-31.637307, -60.695934), false, (GoogleMapIcon)symbol));
        this.add(new Component[]{gmaps});
    }
}

