/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.fle;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FilterableLayoutExtension
implements Serializable {
    private String filteredStyleName = null;
    private Map<Element, Element> containersToFilter = new HashMap<Element, Element>();
    private boolean hideFilteredComponents = true;

    public FilterableLayoutExtension(TextField textField, Element mainElement) {
        textField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.filterComponents((String)e.getValue(), mainElement));
    }

    public void filterComponents(String filter, Element mainElement) {
        Iterator<Element> it = mainElement.getChildren().iterator();
        this.hideFilteredElements(filter, it);
    }

    public void addContainerToFilter(Element triggerer, Element container) {
        this.containersToFilter.put(triggerer, container);
    }

    private boolean hideFilteredElements(String filter, Iterator<Element> iterator) {
        boolean result = false;
        while (iterator.hasNext()) {
            String captionToFilter;
            boolean visible;
            Iterator<Object> it;
            boolean filteredContainer = false;
            Element element = iterator.next();
            if (element.getChildCount() > 0) {
                it = element.getChildren().iterator();
                visible = this.hideFilteredElements(filter, it);
                element.setVisible(visible);
                result |= visible;
                filteredContainer = visible;
            }
            if (this.containersToFilter.containsKey(element)) {
                it = this.containersToFilter.get(element).getChildren().iterator();
                visible = this.hideFilteredElements(filter, it);
                element.setVisible(visible);
                result |= visible;
                filteredContainer = visible;
            }
            if ((captionToFilter = element.getProperty("label")) == null) {
                captionToFilter = element.getText();
            }
            boolean filterMatched = this.filterMatch(filter, captionToFilter) || filteredContainer;
            try {
                boolean visible2 = filterMatched || !this.hideFilteredComponents;
                element.setVisible(visible2);
                boolean bl = result = result || filterMatched;
                if (this.filteredStyleName != null && filterMatched && filter != null && !filter.equals("") && !filteredContainer) {
                    element.getClassList().add((Object)this.filteredStyleName);
                    continue;
                }
                element.getClassList().remove((Object)this.filteredStyleName);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        return result;
    }

    private boolean filterMatch(String filter, String caption) {
        if (filter == null || "".equals(filter)) {
            return true;
        }
        return caption.toLowerCase().indexOf(filter.toLowerCase()) > -1;
    }

    public String getFilteredStyleName() {
        return this.filteredStyleName;
    }

    public void setFilteredStyleName(String filteredStyleName) {
        this.filteredStyleName = filteredStyleName;
    }

    public boolean isHideFilteredComponents() {
        return this.hideFilteredComponents;
    }

    public void setHideFilteredComponents(boolean hideFilteredComponents) {
        this.hideFilteredComponents = hideFilteredComponents;
    }
}

