/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.fle;

import com.flowingcode.vaadin.addons.fle.FilterableLayoutExtension;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import java.io.Serializable;
import java.util.Arrays;

@StyleSheet(value="context://frontend/styles/filterable-layout/demo-styles.css")
public class FilterableLayoutDemo
extends VerticalLayout {
    private static final String SALES_INFORMATION = "Sales Information";
    private static final String COMPANY_INFORMATION = "Company Information";
    private static final String EMPLOYEE_INFORMATION = "Employee Information";

    public FilterableLayoutDemo() {
        VerticalLayout content = new VerticalLayout();
        content.setSpacing(true);
        VerticalLayout vl = new VerticalLayout();
        Tabs ts = new Tabs();
        Component tab1Content = this.createTab1();
        Component tab2Content = this.createTab2();
        Component tab3Content = this.createTab3();
        VerticalLayout tabContent = new VerticalLayout();
        tabContent.add(new Component[]{tab1Content});
        Tab tab1 = new Tab(EMPLOYEE_INFORMATION);
        Tab tab2 = new Tab(COMPANY_INFORMATION);
        Tab tab3 = new Tab(SALES_INFORMATION);
        ts.add(new Tab[]{tab1});
        ts.add(new Tab[]{tab2});
        ts.add(new Tab[]{tab3});
        ts.addSelectedChangeListener((ComponentEventListener & Serializable)ev -> {
            switch (ev.getSelectedTab().getLabel()) {
                case "Employee Information": {
                    tabContent.removeAll();
                    tabContent.add(new Component[]{tab1Content});
                    break;
                }
                case "Company Information": {
                    tabContent.removeAll();
                    tabContent.add(new Component[]{tab2Content});
                    break;
                }
                case "Sales Information": {
                    tabContent.removeAll();
                    tabContent.add(new Component[]{tab3Content});
                    break;
                }
            }
        });
        ts.setWidth("100%");
        vl.add(new Component[]{ts});
        vl.add(new Component[]{tabContent});
        FormLayout gl = new FormLayout();
        gl.setWidth("100%");
        gl.add(new Component[]{this.createTextField("Identification number")});
        gl.add(new Component[]{this.createComboBox("Information Type")});
        gl.add(new Component[]{this.createTextField("Comment")});
        gl.add(new Component[]{this.createTextField("EMail")});
        gl.add(new Component[]{this.createDateField("Birthday")});
        vl.add(new Component[]{gl});
        vl.setSizeFull();
        vl.setMargin(false);
        TextField filter = this.createTextField("Filter");
        filter.setValueChangeMode(ValueChangeMode.LAZY);
        filter.setValueChangeTimeout(500);
        FilterableLayoutExtension flayout = new FilterableLayoutExtension(filter, vl.getElement());
        flayout.addContainerToFilter(tab1.getElement(), tab1Content.getElement());
        flayout.addContainerToFilter(tab2.getElement(), tab2Content.getElement());
        flayout.addContainerToFilter(tab3.getElement(), tab3Content.getElement());
        flayout.setFilteredStyleName("filtered");
        filter.setWidth("100%");
        Checkbox cb = new Checkbox("Hide filtered components");
        cb.setValue((Object)true);
        cb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            flayout.setHideFilteredComponents(((Boolean)e.getValue()).booleanValue());
            flayout.filterComponents(filter.getValue(), vl.getElement());
        });
        content.add(new Component[]{filter, cb, vl});
        this.add(new Component[]{content});
    }

    private Component createDateField(String string) {
        DatePicker result = new DatePicker(string);
        result.setWidth("100%");
        return result;
    }

    private Component createComboBox(String string) {
        ComboBox result = new ComboBox(string, Arrays.asList("Option 1", "Option 2", "Option 3"));
        result.setWidth("100%");
        return result;
    }

    private TextField createTextField(String string) {
        TextField result = new TextField(string);
        result.setWidth("100%");
        return result;
    }

    private Component createTab3() {
        FormLayout fl = new FormLayout();
        fl.setWidth("100%");
        fl.add(new Component[]{this.createTextField("Sales contact")});
        fl.add(new Component[]{this.createComboBox("Sales size")});
        fl.add(new Component[]{this.createTextField("Comments")});
        fl.add(new Component[]{this.createTextField("Senders address")});
        fl.add(new Component[]{this.createDateField("Sale date")});
        return fl;
    }

    private Component createTab2() {
        FormLayout fl = new FormLayout();
        fl.setWidth("100%");
        fl.add(new Component[]{this.createTextField("Company name")});
        fl.add(new Component[]{this.createComboBox("Sector")});
        fl.add(new Component[]{this.createTextField("Tax ID")});
        fl.add(new Component[]{this.createTextField("Address")});
        fl.add(new Component[]{this.createDateField("Start Date")});
        return fl;
    }

    private Component createTab1() {
        FormLayout fl = new FormLayout();
        fl.setWidth("100%");
        fl.add(new Component[]{this.createTextField("Name")});
        fl.add(new Component[]{this.createComboBox("Customer type")});
        fl.add(new Component[]{this.createTextField("Address")});
        fl.add(new Component[]{this.createTextField("City")});
        fl.add(new Component[]{this.createDateField("Birthday")});
        return fl;
    }
}

