/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.errorwindow;

import com.flowingcode.vaadin.addons.errorwindow.ErrorManager;
import com.flowingcode.vaadin.addons.errorwindow.ErrorView;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.InternalServerError;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.SessionInitListener;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import java.io.Serializable;
import java.util.Collections;

public class VaadinServiceInitListenerImpl
implements VaadinServiceInitListener {
    private static final long serialVersionUID = 1L;
    private static boolean productionMode;

    public void serviceInit(ServiceInitEvent event) {
        productionMode = event.getSource().getDeploymentConfiguration().isProductionMode();
        event.getSource().addSessionInitListener((SessionInitListener & Serializable)ev -> ev.getSession().setErrorHandler(this::handleError));
        this.registerErrorView(event.getSource());
    }

    private void registerErrorView(VaadinService source) {
        VaadinContext context = VaadinService.getCurrent().getContext();
        ApplicationRouteRegistry registry = ApplicationRouteRegistry.getInstance((VaadinContext)context);
        Class configuredExceptionHandler = registry.getConfiguration().getExceptionHandlerByClass(Exception.class);
        if (configuredExceptionHandler == InternalServerError.class) {
            registry.setErrorNavigationTargets(Collections.singleton(ErrorView.class));
        }
    }

    private void handleError(ErrorEvent event) {
        if (UI.getCurrent() != null) {
            ErrorManager.showError(event.getThrowable());
        } else {
            event.getThrowable().printStackTrace();
        }
    }

    static boolean getProductionMode() {
        return productionMode;
    }
}

