/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.errorwindow;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.errorwindow.ErrorManager;
import com.flowingcode.vaadin.addons.errorwindow.ErrorWindow;
import com.flowingcode.vaadin.addons.errorwindow.ErrorWindowFactory;
import com.flowingcode.vaadin.addons.errorwindow.ErrorWindowI18n;
import com.flowingcode.vaadin.addons.errorwindow.ErrorwindowDemoView;
import com.flowingcode.vaadin.addons.errorwindow.I18nErrorWindowFactory;
import com.flowingcode.vaadin.addons.errorwindow.NullMemoryBuffer;
import com.flowingcode.vaadin.addons.errorwindow.ThrowInConstructorView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.Optional;

@DemoSource
@PageTitle(value="Error Window Demo")
@Route(value="error-window/error-window", layout=ErrorwindowDemoView.class)
public class ErrorwindowDemo
extends VerticalLayout {
    public ErrorwindowDemo() {
        ErrorWindowI18n errorWindowI18n = ErrorWindowI18n.create((SerializableFunction & Serializable)x$0 -> this.getTranslation((String)x$0, new Object[0]));
        ErrorManager.setErrorWindowFactory((ErrorWindowFactory)new I18nErrorWindowFactory(errorWindowI18n));
        Button errorButton = new Button("Throw Error", (ComponentEventListener & Serializable)event -> Integer.parseInt("asdf"));
        Button throwErrorWithoutErrorHandler = new Button("Throw Error without an error handler", (ComponentEventListener & Serializable)ev -> {
            try {
                Integer.parseInt("asdf");
            }
            catch (NumberFormatException e) {
                ErrorManager.showError((Throwable)e);
            }
        });
        Button throwErrorWithCustomMessageAndCustomTexts = new Button("Throw Error with custom message (custom labels)", (ComponentEventListener & Serializable)ev -> {
            try {
                Integer.parseInt("asdf");
            }
            catch (NumberFormatException e) {
                ErrorWindowI18n i18n = ErrorWindowI18n.createDefault();
                i18n.setCaption("Uh oh... that's embarrassing");
                i18n.setInstructions("Please pass this unique error identifier to your administrator");
                i18n.setClose("Ok");
                i18n.setDetails("Show me technical details");
                i18n.setDefaultErrorMessage("Something really strange happened");
                ErrorWindow w = new ErrorWindow((Throwable)e, "CUSTOM ERROR MESSAGE", i18n);
                w.open();
            }
        });
        Button throwErrori18nSupport = new Button("Throw Error with i18n support", (ComponentEventListener & Serializable)ev -> {
            try {
                Integer.parseInt("asdf");
            }
            catch (NumberFormatException e) {
                new ErrorWindow((Throwable)e, "CUSTOM ERROR MESSAGE", errorWindowI18n).open();
            }
        });
        Checkbox productionModeCb = new Checkbox("Production Mode");
        productionModeCb.setValue((Object)this.getProductionMode());
        productionModeCb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.setProductionMode((Boolean)e.getValue());
            Notification.show((String)("Currently production mode is: " + System.getProperty("productionMode")));
        });
        Upload upload = new Upload((Receiver)new NullMemoryBuffer());
        upload.addSucceededListener((ComponentEventListener & Serializable)ev -> {
            throw new UnsupportedOperationException("File upload is not allowed");
        });
        this.setSizeFull();
        this.add(new Component[]{productionModeCb, errorButton, throwErrorWithoutErrorHandler, throwErrorWithCustomMessageAndCustomTexts, throwErrori18nSupport});
        this.add(new Component[]{new Button("Navigation error", (ComponentEventListener & Serializable)ev -> {
            UI current = UI.getCurrent();
            try {
                UI.class.getMethod("navigate", Class.class).invoke((Object)current, ThrowInConstructorView.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        })});
        this.add(new Component[]{upload});
    }

    private boolean getProductionMode() {
        return Optional.ofNullable(System.getProperty("errorWindowProductionMode")).map(Boolean::valueOf).orElseGet(() -> {
            this.setProductionMode(true);
            return Boolean.TRUE;
        });
    }

    private void setProductionMode(boolean mode) {
        System.setProperty("errorWindowProductionMode", Boolean.toString(mode));
    }
}

