/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.errorwindow;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.errorwindow.ErrorEvent;
import com.flowingcode.vaadin.addons.errorwindow.ErrorEventObserver;
import com.flowingcode.vaadin.addons.errorwindow.ErrorManager;
import com.flowingcode.vaadin.addons.errorwindow.ErrorWindowFactory;
import com.flowingcode.vaadin.addons.errorwindow.ErrorWindowI18n;
import com.flowingcode.vaadin.addons.errorwindow.ErrorwindowDemoView;
import com.flowingcode.vaadin.addons.errorwindow.I18nErrorWindowFactory;
import com.flowingcode.vaadin.addons.errorwindow.NullMemoryBuffer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.upload.Receiver;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@DemoSource
@PageTitle(value="Error Event")
@Route(value="error-window/error-event", layout=ErrorwindowDemoView.class)
public class ErrorEventObserverDemo
extends VerticalLayout
implements ErrorEventObserver {
    private VerticalLayout target = new VerticalLayout();

    public void onError(ErrorEvent event) {
        String str = "We handled a " + event.getThrowable().getClass().getName();
        this.target.add(new Component[]{new Div(new Component[]{new Text(str)})});
        event.preventDefault();
    }

    public ErrorEventObserverDemo() {
        ErrorWindowI18n errorWindowI18n = ErrorWindowI18n.create((SerializableFunction & Serializable)x$0 -> this.getTranslation((String)x$0, new Object[0]));
        ErrorManager.setErrorWindowFactory((ErrorWindowFactory)new I18nErrorWindowFactory(errorWindowI18n));
        Button errorButton = new Button("Throw Error", (ComponentEventListener & Serializable)event -> {
            throw new RuntimeException("Uh oh!");
        });
        Button throwErrorWithoutErrorHandler = new Button("Throw Error without an error handler", (ComponentEventListener & Serializable)ev -> {
            try {
                throw new RuntimeException("Uh oh!");
            }
            catch (RuntimeException e) {
                ErrorManager.showError((Throwable)e);
                return;
            }
        });
        Upload upload = new Upload((Receiver)new NullMemoryBuffer());
        upload.addSucceededListener((ComponentEventListener & Serializable)ev -> {
            throw new UnsupportedOperationException("File upload is not allowed");
        });
        this.setSizeFull();
        this.add(new Component[]{errorButton, throwErrorWithoutErrorHandler, upload});
        this.add(new Component[]{this.target});
        this.target.add(new Component[]{new Text("Errors will be appended here:")});
    }
}

