/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.errorwindow;

import com.flowingcode.vaadin.addons.errorwindow.DefaultErrorWindowFactory;
import com.flowingcode.vaadin.addons.errorwindow.ErrorDetails;
import com.flowingcode.vaadin.addons.errorwindow.ErrorEventWindowFactory;
import com.flowingcode.vaadin.addons.errorwindow.ErrorWindowFactory;
import com.vaadin.flow.server.UploadException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public final class ErrorManager {
    private static final Map<Class<?>, ErrorWindowFactory> factories = new ConcurrentHashMap();

    private ErrorManager() {
        throw new IllegalStateException("Utility class not meant to be instantiated");
    }

    public static void showError(Throwable throwable) {
        ErrorManager.showError(throwable, throwable.getLocalizedMessage());
    }

    public static void showError(Throwable throwable, String cause) {
        ErrorDetails details = new ErrorDetails(throwable, cause);
        ErrorManager.getErrorWindowFactory(throwable.getClass()).showError(details);
    }

    public static void setErrorWindowFactory(Class<? extends Throwable> clazz, ErrorWindowFactory errorWindowFactory) {
        factories.put(clazz.asSubclass(Throwable.class), errorWindowFactory);
    }

    public static ErrorWindowFactory getErrorWindowFactory(Class<?> clazz) {
        return Optional.ofNullable(factories.get(clazz)).map(ErrorEventWindowFactory::newInstance).orElseGet(() -> ErrorManager.getErrorWindowFactory(clazz.getSuperclass()));
    }

    public static void setErrorWindowFactory(ErrorWindowFactory errorWindowFactory) {
        factories.put(Throwable.class, errorWindowFactory);
    }

    public static ErrorWindowFactory getErrorWindowFactory() {
        return ErrorManager.getErrorWindowFactory(Throwable.class);
    }

    static {
        factories.put(Object.class, new DefaultErrorWindowFactory());
        factories.put(UploadException.class, details -> {
            Throwable cause = details.getThrowable().getCause();
            if (cause != null) {
                ErrorManager.showError(cause);
            } else {
                ErrorManager.getErrorWindowFactory(Exception.class).showError(details);
            }
        });
    }
}

