/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.errorwindow;

import com.flowingcode.vaadin.addons.errorwindow.ErrorDetails;
import com.flowingcode.vaadin.addons.errorwindow.ErrorEvent;
import com.flowingcode.vaadin.addons.errorwindow.ErrorEventObserver;
import com.flowingcode.vaadin.addons.errorwindow.ErrorWindowFactory;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.EventUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class ErrorEventWindowFactory
implements ErrorWindowFactory {
    private final ErrorWindowFactory delegate;

    private ErrorEventWindowFactory(ErrorWindowFactory delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public static ErrorWindowFactory newInstance(ErrorWindowFactory delegate) {
        return new ErrorEventWindowFactory(delegate);
    }

    @Override
    public void showError(ErrorDetails details) {
        UI ui = UI.getCurrent();
        ErrorEvent event = new ErrorEvent(ui, details.getThrowable());
        ErrorEventWindowFactory.collectErrorEventObservers(ui.getElement()).forEach(observer -> observer.onError(event));
        if (!event.isPreventDefault()) {
            this.delegate.showError(details);
        }
    }

    @Override
    public boolean isProductionMode() {
        return this.delegate.isProductionMode();
    }

    public static List<ErrorEventObserver> collectErrorEventObservers(Element element) {
        return EventUtil.getImplementingComponents(ErrorEventWindowFactory.flattenDescendants(element), ErrorEventObserver.class).collect(Collectors.toList());
    }

    private static Stream<Element> flattenDescendants(Element element) {
        ArrayList descendants = new ArrayList();
        EventUtil.inspectHierarchy((Element)element, descendants, item -> true);
        return descendants.stream();
    }
}

