/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.errorwindow;

import com.flowingcode.vaadin.addons.errorwindow.ErrorDetails;
import com.flowingcode.vaadin.addons.errorwindow.ErrorManager;
import com.flowingcode.vaadin.addons.errorwindow.ErrorWindowI18n;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Html;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.shared.Registration;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.UUID;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CssImport(value="./flowingcode/error-window.css")
public class ErrorWindow
extends Dialog {
    private static final Logger logger = LoggerFactory.getLogger(ErrorWindow.class);
    private VerticalLayout exceptionTraceLayout;
    private final Throwable cause;
    private final String errorMessage;
    private final String uuid = UUID.randomUUID().toString();
    private boolean productionMode;
    private ErrorWindowI18n i18n;
    private Registration attachListenerRegistration;

    public ErrorWindow(Throwable cause) {
        this(cause, null, ErrorWindow.isProductionMode(), ErrorWindowI18n.createDefault());
    }

    public ErrorWindow(Throwable cause, ErrorWindowI18n i18n) {
        this(cause, null, ErrorWindow.isProductionMode(), i18n);
    }

    @Deprecated
    public ErrorWindow(Throwable cause, String errorMessage) {
        this(cause, errorMessage, ErrorWindow.isProductionMode(), ErrorWindowI18n.createDefault());
    }

    public ErrorWindow(Throwable cause, String errorMessage, ErrorWindowI18n i18n) {
        this(cause, errorMessage, ErrorWindow.isProductionMode(), i18n);
    }

    public ErrorWindow(Throwable cause, String errorMessage, boolean productionMode) {
        this(cause, errorMessage, productionMode, ErrorWindowI18n.createDefault());
    }

    public ErrorWindow(Throwable cause, String errorMessage, boolean productionMode, ErrorWindowI18n i18n) {
        this.cause = cause;
        this.errorMessage = errorMessage;
        this.productionMode = productionMode;
        this.i18n = i18n;
        this.attachListenerRegistration = this.addAttachListener((ComponentEventListener & Serializable)ev -> {
            this.attachListenerRegistration = null;
            ev.unregisterListener();
            this.initWindow();
        });
    }

    public Stream<Component> getChildren() {
        if (this.attachListenerRegistration != null) {
            this.attachListenerRegistration.remove();
            this.attachListenerRegistration = null;
            this.initWindow();
        }
        return super.getChildren();
    }

    public ErrorWindow(ErrorDetails errorDetails) {
        this(errorDetails, ErrorWindowI18n.createDefault());
    }

    public ErrorWindow(ErrorDetails errorDetails, boolean productionMode) {
        this(errorDetails.getThrowable(), errorDetails.getCause(), productionMode);
    }

    public ErrorWindow(ErrorDetails errorDetails, ErrorWindowI18n i18n) {
        this(errorDetails.getThrowable(), errorDetails.getCause(), i18n);
    }

    private static boolean isProductionMode() {
        return ErrorManager.getErrorWindowFactory().isProductionMode();
    }

    private void initWindow() {
        if (logger.isErrorEnabled()) {
            logger.error(String.format("Error occurred %s", this.uuid), this.cause);
        }
        this.setWidth("800px");
        this.setCloseOnEsc(true);
        this.setDraggable(true);
        this.getElement().getThemeList().add((Object)"error-window");
        this.add(new Component[]{this.createMainLayout()});
    }

    private VerticalLayout createMainLayout() {
        VerticalLayout mainLayout = new VerticalLayout();
        mainLayout.setSpacing(false);
        mainLayout.setPadding(false);
        mainLayout.setMargin(false);
        mainLayout.setSizeFull();
        Html title = new Html(String.format("<h1 class='title'>%s</h1>", this.i18n.getCaption()));
        title.getElement().getStyle().set("width", "100%");
        mainLayout.add(new Component[]{title});
        Component errorLabel = this.createErrorLabel();
        mainLayout.add(new Component[]{errorLabel});
        mainLayout.setHorizontalComponentAlignment(FlexComponent.Alignment.START, new Component[]{errorLabel});
        HorizontalLayout buttonsLayout = new HorizontalLayout();
        buttonsLayout.setSpacing(true);
        buttonsLayout.setPadding(false);
        buttonsLayout.setMargin(false);
        if (!this.productionMode) {
            buttonsLayout.setWidthFull();
            Button clipboarButton = new Button(this.i18n.getClipboard());
            clipboarButton.getThemeNames().add((Object)ButtonVariant.LUMO_TERTIARY.getVariantName());
            clipboarButton.addClickListener((ComponentEventListener & Serializable)e -> UI.getCurrent().getPage().executeJs("navigator.clipboard.writeText($0)", new Serializable[]{this.getStackTrace()}));
            clipboarButton.getStyle().set("margin-right", "auto");
            buttonsLayout.add(new Component[]{clipboarButton});
            Button button = this.createDetailsButtonLayout();
            buttonsLayout.add(new Component[]{button});
            mainLayout.add(new Component[]{this.createExceptionTraceLayout()});
        }
        Button closeButton = new Button(this.i18n.getClose(), (ComponentEventListener & Serializable)event -> this.close());
        buttonsLayout.add(new Component[]{closeButton});
        mainLayout.add(new Component[]{buttonsLayout});
        mainLayout.setHorizontalComponentAlignment(FlexComponent.Alignment.END, new Component[]{buttonsLayout});
        return mainLayout;
    }

    private Button createDetailsButtonLayout() {
        Button errorDetailsButton = new Button(this.i18n.getDetails(), (ComponentEventListener & Serializable)event -> {
            boolean visible = !this.exceptionTraceLayout.isVisible();
            this.exceptionTraceLayout.setVisible(visible);
            if (visible) {
                ((Button)event.getSource()).setIcon((Component)VaadinIcon.MINUS.create());
            } else {
                ((Button)event.getSource()).setIcon((Component)VaadinIcon.PLUS.create());
            }
            this.setResizable(visible);
            ((Button)event.getSource()).getElement().executeJs("var overlay = this.closest('vaadin-dialog-overlay'); if (overlay) overlay.$.overlay.style.height=''", new Serializable[0]);
        });
        errorDetailsButton.setIcon((Component)VaadinIcon.PLUS.create());
        return errorDetailsButton;
    }

    private VerticalLayout createExceptionTraceLayout() {
        Component stackTraceArea = this.createStackTraceArea();
        this.exceptionTraceLayout = new VerticalLayout();
        this.exceptionTraceLayout.setSpacing(false);
        this.exceptionTraceLayout.setMargin(false);
        this.exceptionTraceLayout.setPadding(false);
        this.exceptionTraceLayout.add(new Component[]{stackTraceArea});
        this.exceptionTraceLayout.setFlexGrow(1.0, new HasElement[]{stackTraceArea});
        this.exceptionTraceLayout.setVisible(false);
        this.exceptionTraceLayout.getElement().getStyle().set("flex-grow", "1");
        return this.exceptionTraceLayout;
    }

    protected Component createStackTraceArea() {
        Div area = new Div();
        area.setClassName("stacktrace");
        area.setWidthFull();
        area.setHeight("15em");
        area.add(this.getStackTrace());
        return area;
    }

    private String getStackTrace() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        this.cause.printStackTrace(pw);
        pw.flush();
        return baos.toString();
    }

    protected Component createErrorLabel() {
        Div errorLabel = new Div();
        errorLabel.setClassName("errorlabel");
        if (this.productionMode) {
            Div instructions = new Div(new Component[]{new Text(this.i18n.getInstructions())});
            Span uuidSpan = new Span(this.uuid);
            uuidSpan.setClassName("uuid");
            errorLabel.add(new Component[]{instructions, uuidSpan});
        } else {
            String label = this.errorMessage == null ? this.i18n.getDefaultErrorMessage() : this.errorMessage;
            errorLabel.setText(label);
        }
        return errorLabel;
    }
}

