/*-
 * #%L
 * Error Window Add-on
 * %%
 * Copyright (C) 2017 - 2023 Flowing Code
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package com.flowingcode.vaadin.addons.errorwindow;

import com.vaadin.flow.component.UI;
import java.util.EventObject;

/**
 * Event object with a exception trace.
 */
public class ErrorEvent extends EventObject {

  private Throwable throwable;

  private boolean preventDefault;

  public ErrorEvent(UI ui, Throwable throwable) {
    super(ui);
    this.throwable = throwable;
  }

  public Throwable getThrowable() {
    return throwable;
  }

  /** Prevents the default processing by {@link ErrorWindowFactory}. */
  public void preventDefault() {
    preventDefault = true;
  }

  public boolean isPreventDefault() {
    return preventDefault;
  }

}
