/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.demo;

import com.flowingcode.vaadin.addons.DevSourceRequestHandler;
import com.flowingcode.vaadin.jsonmigration.JsonMigration;
import com.vaadin.flow.component.ClickNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.VaadinService;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.Map;

@JsModule(value="./code-viewer.ts")
public class SourceCodeViewer
extends Div
implements HasSize {
    private final Element codeViewer = new Element("code-viewer");

    public SourceCodeViewer(String sourceUrl) {
        this(sourceUrl, null);
    }

    public SourceCodeViewer(String sourceUrl, Map<String, String> properties) {
        this(sourceUrl, "java", properties);
    }

    public SourceCodeViewer(String url, String language, Map<String, String> properties) {
        this.getElement().appendChild(new Element[]{this.codeViewer});
        this.getElement().getStyle().set("overflow", "auto");
        this.getElement().getStyle().set("display", "flex");
        this.codeViewer.getStyle().set("flex-grow", "1");
        this.setProperties(properties);
        this.addAttachListener((ComponentEventListener & Serializable)ev -> this.fetchContents(url, language));
    }

    public void fetchContents(String url, String language) {
        url = SourceCodeViewer.translateSource(url);
        JsonMigration.executeJs((Element)this.codeViewer, (String)"this.fetchContents($0,$1)", (Serializable[])new Serializable[]{url, language});
    }

    private static String translateSource(String url) {
        String src;
        if (!VaadinService.getCurrent().getDeploymentConfiguration().isProductionMode() && DevSourceRequestHandler.fileExists(src = url.replaceFirst("^.*/src/", "/src/"))) {
            return src;
        }
        if (url.startsWith("https://github.com")) {
            url = url.replaceFirst("github.com", "raw.githubusercontent.com");
            url = url.replaceFirst("/blob", "");
        }
        return url;
    }

    private void setProperties(Map<String, String> properties) {
        if (properties != null) {
            JsonObject env = Json.createObject();
            properties.forEach((k, v) -> {
                if (v != null) {
                    env.put(k, (JsonValue)Json.create((String)v));
                }
            });
            JsonMigration.setPropertyJson((Element)this.codeViewer, (String)"env", (JsonValue)env);
        }
    }

    public static void highlightOnHover(Component c, String filenameAndId) {
        c.addAttachListener((ComponentEventListener & Serializable)ev -> JsonMigration.executeJs((Element)c.getElement(), (String)"Vaadin.Flow.fcCodeViewerConnector.highlightOnHover(this,$0)", (Serializable[])new Serializable[]{filenameAndId}));
    }

    public static <T extends HasElement & ClickNotifier<?>> void highlightOnClick(T c, String filenameAndId) {
        ((ClickNotifier<?>)c).addClickListener((ComponentEventListener & Serializable)ev -> JsonMigration.executeJs((Element)c.getElement(), (String)"Vaadin.Flow.fcCodeViewerConnector.highlight($0)", (Serializable[])new Serializable[]{filenameAndId}));
    }

    public static void highlight(String filenameAndId) {
        JsonMigration.executeJs((Element)UI.getCurrent().getElement(), (String)"Vaadin.Flow.fcCodeViewerConnector.highlight($0)", (Serializable[])new Serializable[]{filenameAndId});
    }
}

