/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.demo;

import com.flowingcode.vaadin.addons.demo.TabbedDemo;
import com.flowingcode.vaadin.addons.enhancedtabs.EnhancedTabs;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HighlightAction;
import com.vaadin.flow.router.HighlightConditions;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLink;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class EnhancedRouteTabs
extends Composite<EnhancedTabs>
implements BeforeEnterObserver {
    private final Map<RouterLink, Tab> routerLinkTabMap = new LinkedHashMap<RouterLink, Tab>();

    public void add(String text, Class<? extends Component> target) {
        if (!text.equals("Basic Demo")) {
            text = text.replaceFirst("\\s++[Dd]emo$", "");
        }
        RouterLink routerLink = ((EnhancedTabs)this.getContent()).addRouterLink(text, target);
        routerLink.setHighlightCondition(HighlightConditions.sameLocation());
        routerLink.setHighlightAction((HighlightAction & Serializable)(link, shouldHighlight) -> {
            if (shouldHighlight) {
                this.setSelectedTab(this.routerLinkTabMap.get(routerLink));
            }
        });
        Tab tab = ((EnhancedTabs)this.getContent()).getTabAt(((EnhancedTabs)this.getContent()).getTabCount() - 1);
        this.routerLinkTabMap.put(routerLink, tab);
    }

    private void setSelectedTab(Tab tab) {
        ((EnhancedTabs)this.getContent()).setSelectedTab(tab);
    }

    public void beforeEnter(BeforeEnterEvent event) {
        this.setSelectedTab(null);
        if (TabbedDemo.class.isAssignableFrom(event.getNavigationTarget())) {
            RouterLink first = this.getFirstRoute();
            if (first != null) {
                event.forwardTo(first.getHref());
            } else {
                this.getChildren().findFirst().ifPresent(tab -> this.setSelectedTab((Tab)tab));
            }
        }
    }

    private RouterLink getFirstRoute() {
        Optional<RouterLink> first = this.routerLinkTabMap.entrySet().stream().map(Map.Entry::getKey).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    @Deprecated
    public void addLegacyTab(String label, Component content) {
        Tab tab = new Tab(label);
        ((EnhancedTabs)this.getContent()).add(new Tab[]{tab});
        ((EnhancedTabs)this.getContent()).addSelectedChangeListener((ComponentEventListener & Serializable)ev -> {
            if (ev.getSelectedTab() == tab) {
                TabbedDemo tabbedDemo = (TabbedDemo)((Object)((Object)this.getParent().get()));
                String route = ((Object)((Object)tabbedDemo)).getClass().getAnnotation(Route.class).value();
                UI.getCurrent().getPage().getHistory().pushState(null, new Location(route));
                tabbedDemo.removeRouterLayoutContent(null);
                tabbedDemo.showRouterLayoutContent((HasElement)content);
            }
        });
    }
}

