/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.demo;

import com.flowingcode.vaadin.addons.demo.MultiSourceCodeViewer;
import com.flowingcode.vaadin.addons.demo.SourceCodeTab;
import com.flowingcode.vaadin.addons.demo.SourcePosition;
import com.flowingcode.vaadin.addons.demo.VaadinVersion;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.server.Version;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

class SplitLayoutDemo
extends Composite<SplitLayout> {
    private MultiSourceCodeViewer code;
    private SourcePosition sourcePosition;

    public SplitLayoutDemo(Component demo, String sourceUrl, SourcePosition sourcePosition) {
        this(demo, Arrays.asList(new SourceCodeTab(sourceUrl, sourcePosition)));
    }

    public SplitLayoutDemo(Component demo, List<SourceCodeTab> tabs) {
        ((SplitLayout)this.getContent()).setOrientation(SplitLayout.Orientation.HORIZONTAL);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("vaadin", VaadinVersion.getVaadinVersion());
        properties.put("flow", Version.getFullVersion());
        this.code = new MultiSourceCodeViewer(tabs, properties);
        this.sourcePosition = this.code.getSourcePosition();
        switch (this.sourcePosition) {
            case PRIMARY: {
                ((SplitLayout)this.getContent()).addToPrimary(new Component[]{this.code});
                ((SplitLayout)this.getContent()).addToSecondary(new Component[]{demo});
                break;
            }
            default: {
                ((SplitLayout)this.getContent()).addToPrimary(new Component[]{demo});
                ((SplitLayout)this.getContent()).addToSecondary(new Component[]{this.code});
            }
        }
        ((SplitLayout)this.getContent()).setSizeFull();
    }

    public void switchSourcePosition(SourcePosition position) {
        if (!this.sourcePosition.equals((Object)position)) {
            this.toggleSourcePosition();
        }
    }

    public void toggleSourcePosition() {
        Component primary = ((SplitLayout)this.getContent()).getPrimaryComponent();
        Component secondary = ((SplitLayout)this.getContent()).getSecondaryComponent();
        ((SplitLayout)this.getContent()).removeAll();
        ((SplitLayout)this.getContent()).addToPrimary(new Component[]{secondary});
        ((SplitLayout)this.getContent()).addToSecondary(new Component[]{primary});
        this.sourcePosition = this.sourcePosition.toggle();
    }

    public void setOrientation(SplitLayout.Orientation o) {
        ((SplitLayout)this.getContent()).setOrientation(o);
        ((SplitLayout)this.getContent()).getPrimaryComponent().getElement().setAttribute("style", "width: 100%; height: 100%");
        this.code.setSizeFull();
    }

    public SplitLayout.Orientation getOrientation() {
        return ((SplitLayout)this.getContent()).getOrientation();
    }

    public void setSplitterPosition(int pos) {
        ((SplitLayout)this.getContent()).setSplitterPosition((double)pos);
    }

    public void setSizeFull() {
        ((SplitLayout)this.getContent()).setSizeFull();
    }

    public void showSourceCode() {
        ((SplitLayout)this.getContent()).setSplitterPosition(50.0);
    }

    public void hideSourceCode() {
        switch (this.sourcePosition) {
            case PRIMARY: {
                ((SplitLayout)this.getContent()).setSplitterPosition(0.0);
                break;
            }
            case SECONDARY: {
                ((SplitLayout)this.getContent()).setSplitterPosition(100.0);
            }
        }
    }
}

