/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.demo;

import com.flowingcode.vaadin.addons.demo.SourcePosition;
import lombok.NonNull;

public class SourceCodeTab {
    @NonNull
    private final String url;
    private String caption;
    private String language;
    @NonNull
    private final SourcePosition sourcePosition;

    public static SourceCodeTabBuilder builder() {
        return new SourceCodeTabBuilder();
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getLanguage() {
        return this.language;
    }

    @NonNull
    public SourcePosition getSourcePosition() {
        return this.sourcePosition;
    }

    public SourceCodeTab(@NonNull String url, @NonNull SourcePosition sourcePosition) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (sourcePosition == null) {
            throw new NullPointerException("sourcePosition is marked non-null but is null");
        }
        this.url = url;
        this.sourcePosition = sourcePosition;
    }

    private SourceCodeTab(@NonNull String url, String caption, String language, @NonNull SourcePosition sourcePosition) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        if (sourcePosition == null) {
            throw new NullPointerException("sourcePosition is marked non-null but is null");
        }
        this.url = url;
        this.caption = caption;
        this.language = language;
        this.sourcePosition = sourcePosition;
    }

    public static class SourceCodeTabBuilder {
        private String url;
        private String caption;
        private String language;
        private SourcePosition sourcePosition;

        SourceCodeTabBuilder() {
        }

        public SourceCodeTabBuilder url(@NonNull String url) {
            if (url == null) {
                throw new NullPointerException("url is marked non-null but is null");
            }
            this.url = url;
            return this;
        }

        public SourceCodeTabBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public SourceCodeTabBuilder language(String language) {
            this.language = language;
            return this;
        }

        public SourceCodeTabBuilder sourcePosition(@NonNull SourcePosition sourcePosition) {
            if (sourcePosition == null) {
                throw new NullPointerException("sourcePosition is marked non-null but is null");
            }
            this.sourcePosition = sourcePosition;
            return this;
        }

        public SourceCodeTab build() {
            return new SourceCodeTab(this.url, this.caption, this.language, this.sourcePosition);
        }

        public String toString() {
            return "SourceCodeTab.SourceCodeTabBuilder(url=" + this.url + ", caption=" + this.caption + ", language=" + this.language + ", sourcePosition=" + this.sourcePosition + ")";
        }
    }
}

