/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons;

import com.vaadin.flow.server.RequestHandler;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.VaadinSession;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DevSourceRequestHandler
implements RequestHandler {
    private static final int SC_OK = 200;
    private static final int SC_NOT_FOUND = 404;

    public boolean handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (VaadinService.getCurrent().getDeploymentConfiguration().isProductionMode()) {
            return false;
        }
        String path = request.getPathInfo();
        if (!path.startsWith("/src/")) {
            return false;
        }
        if (DevSourceRequestHandler.fileExists(path)) {
            byte[] file = FileUtils.readFileToByteArray((File)DevSourceRequestHandler.getFile(path));
            response.setStatus(200);
            IOUtils.write((byte[])file, (OutputStream)response.getOutputStream());
        } else {
            response.setStatus(404);
        }
        return true;
    }

    public static boolean fileExists(String path) {
        return DevSourceRequestHandler.getFile(path).exists();
    }

    private static File getFile(String path) {
        return new File(path.substring(1));
    }
}

