/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.demo;

import com.flowingcode.vaadin.addons.GithubLink;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.demo.RouteTabs;
import com.flowingcode.vaadin.addons.demo.SplitLayoutDemo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RouterLink;
import java.io.Serializable;
import java.util.Optional;

@StyleSheet(value="context://frontend/styles/commons-demo/shared-styles.css")
@JsModule(value="./toggle-theme.js")
public class TabbedDemo
extends VerticalLayout
implements RouterLayout {
    private RouteTabs tabs = new RouteTabs();
    private HorizontalLayout footer;
    private SplitLayoutDemo currentLayout;
    private Checkbox orientationCB;
    private Checkbox codeCB;
    private Checkbox themeCB;

    public TabbedDemo() {
        this.tabs.setWidthFull();
        this.orientationCB = new Checkbox("Toggle Orientation");
        this.orientationCB.setValue((Object)true);
        this.orientationCB.addClassName("smallcheckbox");
        this.orientationCB.addValueChangeListener((HasValue.ValueChangeListener & Serializable)cb -> this.updateSplitterOrientation());
        this.codeCB = new Checkbox("Show Source Code");
        this.codeCB.setValue((Object)true);
        this.codeCB.addClassName("smallcheckbox");
        this.codeCB.addValueChangeListener((HasValue.ValueChangeListener & Serializable)cb -> this.updateSplitterPosition());
        this.themeCB = new Checkbox("Dark Theme");
        this.themeCB.setValue((Object)false);
        this.themeCB.addClassName("smallcheckbox");
        this.themeCB.addValueChangeListener((HasValue.ValueChangeListener & Serializable)cb -> this.updateDemoTheme());
        this.footer = new HorizontalLayout();
        this.footer.setWidthFull();
        this.footer.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        this.footer.add(new Component[]{this.codeCB, this.orientationCB, this.themeCB});
        this.footer.setClassName("demo-footer");
        Package pkg = ((Object)((Object)this)).getClass().getPackage();
        String title = pkg.getImplementationTitle();
        String version = pkg.getImplementationVersion();
        if (title != null && version != null) {
            Div footerLeft = new Div();
            this.footer.setFlexGrow(1.0, new HasElement[]{footerLeft});
            this.footer.addComponentAsFirst((Component)footerLeft);
            footerLeft.add(new Component[]{new Span(title + " " + version)});
        }
        this.add(new Component[]{this.tabs});
        this.add(new Component[]{new Div()});
        this.add(new Component[]{this.footer});
        this.setSizeFull();
    }

    @Deprecated
    public void addDemo(Component demo) {
        DemoSource demoSource = demo.getClass().getAnnotation(DemoSource.class);
        String label = Optional.ofNullable(demo.getClass().getAnnotation(PageTitle.class)).map(PageTitle::value).orElse(demo.getClass().getSimpleName());
        this.addDemo(demo, label, null);
    }

    @Deprecated
    public void addDemo(Component demo, String label, String sourceCodeUrl) {
        this.tabs.addLegacyTab(label, demo);
    }

    public void addDemo(Class<? extends Component> clazz, String label) {
        if (!clazz.isAnnotationPresent(Route.class)) {
            throw new IllegalArgumentException(clazz + " must be annotated as Route");
        }
        RouterLink tab = new RouterLink(label, clazz);
        this.tabs.add(tab);
    }

    public void addDemo(Class<? extends Component> clazz) {
        String label = Optional.ofNullable(clazz.getAnnotation(PageTitle.class)).map(PageTitle::value).orElse(clazz.getSimpleName());
        this.addDemo(clazz, label);
    }

    @Deprecated
    public void addDemo(Component demo, String label) {
        this.addDemo(demo, label, null);
    }

    public void showRouterLayoutContent(HasElement content) {
        Component demo = (Component)content;
        if (!demo.getId().isPresent()) {
            demo.setId("content");
        }
        DemoSource demoSource = demo.getClass().getAnnotation(DemoSource.class);
        String sourceCodeUrl = null;
        if (demoSource != null) {
            sourceCodeUrl = demoSource.value();
            if (sourceCodeUrl.equals("__GITHUB__")) {
                sourceCodeUrl = Optional.ofNullable(((Object)((Object)this)).getClass().getAnnotation(GithubLink.class)).map(githubLink -> githubLink.value() + "/blob/master/src/test/java/" + demo.getClass().getName().replace('.', '/') + ".java").orElse(null);
            }
            content = new SplitLayoutDemo(demo, sourceCodeUrl);
            this.currentLayout = (SplitLayoutDemo)((Object)content);
            this.updateSplitterPosition();
            this.updateSplitterOrientation();
        } else {
            this.currentLayout = null;
            demo.getElement().getStyle().set("height", "100%");
        }
        this.updateFooterButtonsVisibility();
        this.getElement().insertChild(1, new Element[]{content.getElement()});
    }

    public void removeRouterLayoutContent(HasElement oldContent) {
        this.getElement().removeChild(1);
    }

    private void updateSplitterPosition() {
        this.setSourceVisible((Boolean)this.codeCB.getValue());
    }

    public void setSourceVisible(boolean visible) {
        this.currentLayout.setSplitterPosition(visible ? 50 : 100);
        this.orientationCB.setEnabled(visible);
    }

    private void updateSplitterOrientation() {
        if (((Boolean)this.orientationCB.getValue()).booleanValue()) {
            this.setOrientation(SplitLayout.Orientation.HORIZONTAL);
        } else {
            this.setOrientation(SplitLayout.Orientation.VERTICAL);
        }
    }

    public SplitLayout.Orientation getOrientation() {
        return this.currentLayout.getOrientation();
    }

    public void setOrientation(SplitLayout.Orientation orientation) {
        this.currentLayout.setOrientation(orientation);
    }

    private void updateDemoTheme() {
        this.getElement().executeJs("toggleTheme.applyTheme($0)", new Serializable[]{(Serializable)this.themeCB.getValue()});
    }

    private void updateFooterButtonsVisibility() {
        this.orientationCB.setVisible(this.currentLayout != null);
        this.codeCB.setVisible(this.currentLayout != null);
    }
}

