/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.demo;

import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;

@JsModule(value="./code-viewer.ts")
@NpmPackage(value="lit", version="2.5.0")
class SourceCodeView
extends Div
implements HasSize {
    public SourceCodeView(String sourceUrl) {
        String url = SourceCodeView.translateSource(sourceUrl);
        Element codeViewer = new Element("code-viewer");
        this.getElement().appendChild(new Element[]{codeViewer});
        this.getElement().getStyle().set("display", "flex");
        codeViewer.getStyle().set("flex-grow", "1");
        this.addAttachListener((ComponentEventListener & Serializable)ev -> codeViewer.executeJs("this.fetchContents($0,$1)", new Serializable[]{url, "java"}));
    }

    private static String translateSource(String url) {
        if (url.startsWith("https://github.com")) {
            url = url.replaceFirst("github.com", "raw.githubusercontent.com");
            url = url.replaceFirst("/blob", "");
        }
        return url;
    }
}

