/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.demo;

import com.flowingcode.vaadin.addons.demo.TabbedDemo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterObserver;
import com.vaadin.flow.router.HighlightAction;
import com.vaadin.flow.router.HighlightConditions;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLink;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class RouteTabs
extends Tabs
implements BeforeEnterObserver {
    private final Map<RouterLink, Tab> routerLinkTabMap = new LinkedHashMap<RouterLink, Tab>();

    public void add(RouterLink routerLink) {
        routerLink.setHighlightCondition(HighlightConditions.sameLocation());
        routerLink.setHighlightAction((HighlightAction & Serializable)(link, shouldHighlight) -> {
            if (shouldHighlight) {
                this.setSelectedTab(this.routerLinkTabMap.get(routerLink));
            }
        });
        this.routerLinkTabMap.put(routerLink, new Tab(new Component[]{routerLink}));
        this.add(new Tab[]{this.routerLinkTabMap.get(routerLink)});
    }

    public void beforeEnter(BeforeEnterEvent event) {
        this.setSelectedTab(null);
        if (TabbedDemo.class.isAssignableFrom(event.getNavigationTarget())) {
            RouterLink first = this.getFirstRoute();
            if (first != null) {
                event.forwardTo(first.getHref());
            } else {
                this.getChildren().findFirst().ifPresent(tab -> this.setSelectedTab((Tab)tab));
            }
        }
    }

    public Map<RouterLink, Tab> getRouterLinkTabMap() {
        return this.routerLinkTabMap;
    }

    public RouterLink getFirstRoute() {
        Optional<RouterLink> first = this.routerLinkTabMap.entrySet().stream().map(Map.Entry::getKey).findFirst();
        return first.isPresent() ? first.get() : null;
    }

    @Deprecated
    public void addLegacyTab(String label, Component content) {
        Tab tab = new Tab(label);
        this.add(new Tab[]{tab});
        this.addSelectedChangeListener((ComponentEventListener & Serializable)ev -> {
            if (ev.getSelectedTab() == tab) {
                TabbedDemo tabbedDemo = (TabbedDemo)((Object)((Object)this.getParent().get()));
                String route = ((Object)((Object)tabbedDemo)).getClass().getAnnotation(Route.class).value();
                UI.getCurrent().getPage().getHistory().pushState(null, new Location(route));
                tabbedDemo.removeRouterLayoutContent(null);
                tabbedDemo.showRouterLayoutContent((HasElement)content);
            }
        });
    }
}

