/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.demo;

import com.flowingcode.vaadin.addons.GithubBranch;
import com.flowingcode.vaadin.addons.GithubLink;
import com.flowingcode.vaadin.addons.demo.DemoHelper;
import com.flowingcode.vaadin.addons.demo.DemoHelperRenderer;
import com.flowingcode.vaadin.addons.demo.DemoHelperViewer;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.demo.DialogDemoHelperViewer;
import com.flowingcode.vaadin.addons.demo.RouteTabs;
import com.flowingcode.vaadin.addons.demo.SourceCodeTab;
import com.flowingcode.vaadin.addons.demo.SplitLayoutDemo;
import com.flowingcode.vaadin.addons.demo.TabbedDemoSourceEvent;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.RouterLink;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@StyleSheet(value="context://frontend/styles/commons-demo/shared-styles.css")
public class TabbedDemo
extends VerticalLayout
implements RouterLayout {
    private static final Logger logger = LoggerFactory.getLogger(TabbedDemo.class);
    private static final int MOBILE_DEVICE_BREAKPOINT_WIDTH = 768;
    private RouteTabs tabs;
    private HorizontalLayout footer;
    private SplitLayoutDemo currentLayout;
    private Checkbox orientationCB;
    private Checkbox codeCB;
    private Checkbox codePositionCB;
    private Checkbox themeCB;
    private SplitLayout.Orientation splitOrientation;
    private Button helperButton;
    private DemoHelperViewer demoHelperViewer = new DialogDemoHelperViewer();

    public TabbedDemo() {
        this.tabs = new RouteTabs();
        this.tabs.setWidthFull();
        this.orientationCB = new Checkbox("Toggle Orientation");
        this.orientationCB.setValue((Object)true);
        this.orientationCB.addClassName("smallcheckbox");
        this.orientationCB.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> {
            if (ev.isFromClient()) {
                this.toggleSplitterOrientation();
            }
        });
        this.codeCB = new Checkbox("Show Source Code");
        this.codeCB.setValue((Object)true);
        this.codeCB.addClassName("smallcheckbox");
        this.codeCB.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> this.updateSplitterPosition());
        this.codePositionCB = new Checkbox("Toggle Code Position");
        this.codePositionCB.setValue((Object)true);
        this.codePositionCB.addClassName("smallcheckbox");
        this.codePositionCB.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> this.toggleSourcePosition());
        this.themeCB = new Checkbox("Dark Theme");
        this.themeCB.setValue((Object)false);
        this.themeCB.addClassName("smallcheckbox");
        this.themeCB.addValueChangeListener((HasValue.ValueChangeListener & Serializable)cb -> TabbedDemo.applyTheme(this.getElement(), (Boolean)this.themeCB.getValue()));
        this.footer = new HorizontalLayout();
        this.footer.setWidthFull();
        this.footer.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        this.footer.add(new Component[]{this.codeCB, this.codePositionCB, this.orientationCB, this.themeCB});
        this.footer.setClassName("demo-footer");
        Package pkg = ((Object)((Object)this)).getClass().getPackage();
        String title = pkg.getImplementationTitle();
        String version = pkg.getImplementationVersion();
        if (title != null && version != null) {
            Div footerLeft = new Div();
            this.footer.setFlexGrow(1.0, new HasElement[]{footerLeft});
            this.footer.addComponentAsFirst((Component)footerLeft);
            footerLeft.add(new Component[]{new Span(title + " " + version)});
        }
        this.add(new Component[]{this.tabs});
        this.add(new Component[]{new Div()});
        this.add(new Component[]{this.footer});
        this.setSizeFull();
    }

    @Deprecated
    public void addDemo(Component demo) {
        String label = Optional.ofNullable(demo.getClass().getAnnotation(PageTitle.class)).map(PageTitle::value).orElse(demo.getClass().getSimpleName());
        this.addDemo(demo, label, null);
    }

    @Deprecated
    public void addDemo(Component demo, String label, String sourceCodeUrl) {
        this.tabs.addLegacyTab(label, demo);
    }

    public void addDemo(Class<? extends Component> clazz, String label) {
        if (!clazz.isAnnotationPresent(Route.class)) {
            throw new IllegalArgumentException(clazz + " must be annotated as Route");
        }
        RouterLink tab = new RouterLink(label, clazz);
        this.tabs.add(tab);
    }

    public void addDemo(Class<? extends Component> clazz) {
        String label = Optional.ofNullable(clazz.getAnnotation(PageTitle.class)).map(PageTitle::value).orElse(clazz.getSimpleName());
        this.addDemo(clazz, label);
    }

    @Deprecated
    public void addDemo(Component demo, String label) {
        this.addDemo(demo, label, null);
    }

    public void showRouterLayoutContent(HasElement content) {
        Component demo = (Component)content;
        if (!demo.getId().isPresent()) {
            demo.setId("content");
        }
        if (this.helperButton != null) {
            this.remove(new Component[]{this.helperButton});
            this.helperButton = null;
        }
        DemoSource[] demoSources = (DemoSource[])demo.getClass().getAnnotationsByType(DemoSource.class);
        ArrayList<SourceCodeTab> sourceTabs = new ArrayList<SourceCodeTab>(demoSources.length);
        for (DemoSource demoSource : demoSources) {
            this.createSourceCodeTab(demo.getClass(), demoSource).ifPresent(sourceTabs::add);
        }
        if (!sourceTabs.isEmpty()) {
            content = new SplitLayoutDemo(demo, sourceTabs);
            this.currentLayout = (SplitLayoutDemo)((Object)content);
            if (this.splitOrientation != null) {
                this.setOrientation(this.splitOrientation);
                this.updateSplitterPosition();
            }
            if (this.currentLayout != null) {
                this.setupDemoHelperButton(((SplitLayout)this.currentLayout.getContent()).getPrimaryComponent().getClass());
            }
        } else {
            this.currentLayout = null;
            demo.getElement().getStyle().set("height", "100%");
            this.setupDemoHelperButton(content.getClass());
        }
        this.updateFooterButtonsVisibility();
        this.getElement().insertChild(1, new Element[]{content.getElement()});
    }

    private Optional<SourceCodeTab> createSourceCodeTab(Class<?> annotatedClass, DemoSource annotation) {
        String demoFile;
        String url = annotation.value();
        if (url.equals("__GITHUB__")) {
            String className = annotatedClass.getName().replace('.', '/');
            demoFile = "src/test/java/" + className + ".java";
        } else {
            demoFile = url.startsWith("/src/test/") ? url.substring(1) : null;
        }
        if (demoFile != null) {
            String branch = TabbedDemo.lookupGithubBranch(((Object)((Object)this)).getClass());
            url = Optional.ofNullable(((Object)((Object)this)).getClass().getAnnotation(GithubLink.class)).map(githubLink -> String.format("%s/blob/%s/%s", githubLink.value(), branch, demoFile)).orElse(null);
        }
        if (url == null) {
            return Optional.empty();
        }
        SourceCodeTab.SourceCodeTabBuilder builder = SourceCodeTab.builder();
        builder.url(url);
        if (!annotation.caption().equals("__DEFAULT__")) {
            builder.caption(annotation.caption());
        }
        if (!annotation.language().equals("__DEFAULT__")) {
            builder.language(annotation.caption());
        }
        builder.sourcePosition(annotation.sourcePosition());
        return Optional.of(builder.build());
    }

    public static String lookupGithubBranch(Class<? extends TabbedDemo> clazz) {
        Package pkg;
        GithubBranch branch = clazz.getAnnotation(GithubBranch.class);
        if (branch == null && (pkg = clazz.getPackage()) != null) {
            branch = pkg.getAnnotation(GithubBranch.class);
        }
        return Optional.ofNullable(branch).map(GithubBranch::value).orElse("master");
    }

    public void removeRouterLayoutContent(HasElement oldContent) {
        this.getElement().removeChild(1);
    }

    private void updateSplitterPosition() {
        if (this.currentLayout != null) {
            if (((Boolean)this.codeCB.getValue()).booleanValue()) {
                this.currentLayout.showSourceCode();
            } else {
                this.currentLayout.hideSourceCode();
            }
            this.orientationCB.setEnabled(((Boolean)this.codeCB.getValue()).booleanValue());
            this.codePositionCB.setEnabled(((Boolean)this.codeCB.getValue()).booleanValue());
        }
    }

    public void setSourceVisible(boolean visible) {
        this.codeCB.setValue((Object)visible);
        this.codePositionCB.setVisible(visible);
    }

    public void toggleSourcePosition() {
        if (this.currentLayout != null) {
            this.currentLayout.toggleSourcePosition();
        }
    }

    private void toggleSplitterOrientation() {
        if (this.currentLayout == null) {
            return;
        }
        this.splitOrientation = SplitLayout.Orientation.HORIZONTAL.equals((Object)this.splitOrientation) ? SplitLayout.Orientation.VERTICAL : SplitLayout.Orientation.HORIZONTAL;
        this.setOrientation(this.splitOrientation);
    }

    public SplitLayout.Orientation getOrientation() {
        return this.currentLayout.getOrientation();
    }

    public void setOrientation(SplitLayout.Orientation orientation) {
        this.splitOrientation = orientation;
        if (this.currentLayout != null) {
            this.currentLayout.setOrientation(orientation);
            this.currentLayout.setSplitterPosition(50);
        }
        this.orientationCB.setValue((Object)SplitLayout.Orientation.HORIZONTAL.equals((Object)orientation));
    }

    public static void applyTheme(Element element, boolean useDarkTheme) {
        String theme = useDarkTheme ? "dark" : "";
        element.executeJs("document.documentElement.setAttribute('theme', $0);", new Serializable[]{theme});
    }

    private void updateFooterButtonsVisibility() {
        boolean hasSourceCode = this.currentLayout != null;
        ComponentUtil.fireEvent((Component)this, (ComponentEvent)new TabbedDemoSourceEvent((Component)this, hasSourceCode));
        this.orientationCB.setVisible(hasSourceCode);
        this.codeCB.setVisible(hasSourceCode);
        this.codePositionCB.setVisible(hasSourceCode);
    }

    public void addTabbedDemoSourceListener(ComponentEventListener<TabbedDemoSourceEvent> listener) {
        ComponentUtil.addListener((Component)this, TabbedDemoSourceEvent.class, listener);
        listener.onComponentEvent((ComponentEvent)new TabbedDemoSourceEvent((Component)this, this.currentLayout != null));
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getUI().ifPresent(ui -> ui.getPage().retrieveExtendedClientDetails((Page.ExtendedClientDetailsReceiver & Serializable)receiver -> {
            boolean mobile = receiver.getBodyClientWidth() <= 768;
            this.codeCB.setValue((Object)((Boolean)this.codeCB.getValue() != false && !mobile ? 1 : 0));
            this.codePositionCB.setValue((Object)((Boolean)this.codeCB.getValue() != false && !mobile ? 1 : 0));
            boolean portraitOrientation = receiver.getBodyClientHeight() > receiver.getBodyClientWidth();
            this.adjustSplitOrientation(portraitOrientation);
        }));
    }

    private void adjustSplitOrientation(boolean portraitOrientation) {
        this.splitOrientation = portraitOrientation ? SplitLayout.Orientation.VERTICAL : SplitLayout.Orientation.HORIZONTAL;
        this.setOrientation(this.splitOrientation);
    }

    public void setDemoHelperViewer(DemoHelperViewer demoHelperViewer) {
        this.demoHelperViewer = Objects.requireNonNull(demoHelperViewer, "Demo helper viewer cannot be null");
    }

    private void setupDemoHelperButton(Class<?> helperClass) {
        if (helperClass.isAnnotationPresent(DemoHelper.class)) {
            DemoHelper demoHelper = helperClass.getAnnotation(DemoHelper.class);
            try {
                DemoHelperRenderer demoHelperRenderer = demoHelper.renderer().newInstance();
                this.helperButton = new Button((Component)demoHelper.icon().create());
                this.helperButton.getElement().setAttribute("title", demoHelper.tooltipText());
                this.helperButton.addClassName("helper-button");
                this.helperButton.getThemeNames().add((Object)ButtonVariant.LUMO_ICON.getVariantName());
                this.helperButton.getThemeNames().add((Object)ButtonVariant.LUMO_TERTIARY.getVariantName());
                this.helperButton.addClickListener((ComponentEventListener & Serializable)e -> this.demoHelperViewer.show(demoHelperRenderer.helperContent()));
                this.add(new Component[]{this.helperButton});
            }
            catch (Exception e2) {
                logger.error("Error creating an instance", (Throwable)e2);
            }
        }
    }
}

