/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.demo;

import com.flowingcode.vaadin.addons.demo.SourceCodeTab;
import com.flowingcode.vaadin.addons.demo.SourceCodeViewer;
import com.flowingcode.vaadin.addons.demo.SourcePosition;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class MultiSourceCodeViewer
extends Div {
    private static final String DATA_URL = "source-url";
    private static final String DATA_LANGUAGE = "source-language";
    private static final String DATA_POSITION = "source-position";
    private SourceCodeViewer codeViewer;
    private Tab selectedTab;

    public MultiSourceCodeViewer(List<SourceCodeTab> sourceCodeTabs, Map<String, String> properties) {
        if (sourceCodeTabs.size() > 1) {
            Tabs tabs = new Tabs(this.createTabs(sourceCodeTabs));
            tabs.addSelectedChangeListener((ComponentEventListener & Serializable)ev -> this.onTabSelected(ev.getSelectedTab()));
            this.add(new Component[]{tabs});
            this.selectedTab = tabs.getSelectedTab();
        } else {
            this.selectedTab = this.createTab(sourceCodeTabs.get(0));
        }
        String url = (String)ComponentUtil.getData((Component)this.selectedTab, (String)DATA_URL);
        String language = (String)ComponentUtil.getData((Component)this.selectedTab, (String)DATA_LANGUAGE);
        this.codeViewer = new SourceCodeViewer(url, language, properties);
        this.add(new Component[]{this.codeViewer});
        this.codeViewer.getStyle().set("flex-grow", "1");
        this.getStyle().set("display", "flex");
        this.getStyle().set("flex-direction", "column");
    }

    private Tab[] createTabs(List<SourceCodeTab> sourceCodeTabs) {
        return (Tab[])sourceCodeTabs.stream().map(this::createTab).toArray(Tab[]::new);
    }

    private Tab createTab(SourceCodeTab sourceCodeTab) {
        String url = sourceCodeTab.getUrl();
        String language = sourceCodeTab.getLanguage();
        String caption = sourceCodeTab.getCaption();
        String filename = this.getFilename(url);
        if (caption == null) {
            caption = filename;
        }
        if (language == null) {
            String ext;
            switch (ext = this.getExtension(filename)) {
                case "java": {
                    language = "java";
                    break;
                }
                case "css": {
                    language = "css";
                    break;
                }
                case "js": {
                    language = "js";
                    break;
                }
                case "ts": {
                    language = "ts";
                    break;
                }
                default: {
                    language = "unknown";
                }
            }
        }
        Tab tab = new Tab(caption);
        ComponentUtil.setData((Component)tab, (String)DATA_URL, (Object)url);
        ComponentUtil.setData((Component)tab, (String)DATA_LANGUAGE, (Object)language);
        ComponentUtil.setData((Component)tab, (String)DATA_POSITION, (Object)((Object)sourceCodeTab.getSourcePosition()));
        return tab;
    }

    private String getFilename(String url) {
        int i = url.lastIndexOf(47);
        return i >= 0 ? url.substring(i + 1) : url;
    }

    private String getExtension(String filename) {
        int i = filename.lastIndexOf(46);
        return i >= 0 ? filename.substring(i + 1) : filename;
    }

    private void onTabSelected(Tab tab) {
        this.selectedTab = tab;
        String url = (String)ComponentUtil.getData((Component)tab, (String)DATA_URL);
        String language = (String)ComponentUtil.getData((Component)tab, (String)DATA_LANGUAGE);
        this.fetchContents(url, language);
    }

    private void fetchContents(String url, String language) {
        this.codeViewer.fetchContents(url, language);
    }

    public SourcePosition getSourcePosition() {
        return (SourcePosition)((Object)ComponentUtil.getData((Component)this.selectedTab, (String)DATA_POSITION));
    }
}

