/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.dayofweekselector;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.Element;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@CssImport(value="./styles/fc-days-of-week-selector-styles.css")
@JsModule(value="./src/fc-days-of-week-selector.ts")
@Tag(value="fc-days-of-week-selector")
public class DayOfWeekSelector
extends CustomField<Set<DayOfWeek>> {
    private List<DayOfWeekButton> dayButtons = new ArrayList<DayOfWeekButton>();

    public DayOfWeekSelector() {
        this.initDefaultDayButtons();
    }

    public DayOfWeekSelector(DayOfWeek ... value) {
        this();
        if (value.length > 0) {
            this.setValue(value[0], value);
        }
    }

    public DayOfWeekSelector(String label) {
        this();
        this.setLabel(label);
    }

    public DayOfWeekSelector(String label, DayOfWeek ... value) {
        this(value);
        this.setLabel(label);
    }

    public Set<DayOfWeek> getEmptyValue() {
        return EnumSet.noneOf(DayOfWeek.class);
    }

    protected boolean valueEquals(Set<DayOfWeek> value1, Set<DayOfWeek> value2) {
        return value1 != value2 && Objects.equals(value1, value2);
    }

    protected Set<DayOfWeek> generateModelValue() {
        return this.dayButtons.stream().filter(DayOfWeekButton::getState).map(DayOfWeekButton::getDayOfWeek).collect(Collectors.toCollection(() -> this.getEmptyValue()));
    }

    protected void setPresentationValue(Set<DayOfWeek> newPresentationValue) {
        this.dayButtons.forEach(button -> button.setState(newPresentationValue.contains(button.getDayOfWeek())));
    }

    public void setReadOnly(boolean readOnly) {
        this.getElement().setProperty("readonly", readOnly);
        this.getElement().setAttribute("readonly", readOnly);
        this.dayButtons.forEach(button -> {
            button.setEnabled(!readOnly);
            if (readOnly) {
                button.addClassName("readOnly");
            } else {
                button.removeClassName("readOnly");
            }
        });
    }

    public void setValue(DayOfWeek first, DayOfWeek ... rest) {
        this.setValue(EnumSet.of(first, rest));
    }

    public void setI18N(DatePicker.DatePickerI18n i18n) {
        if (i18n.getWeekdaysShort() != null) {
            this.setWeekDaysShort(i18n.getWeekdaysShort());
        }
        if (i18n.getWeekdays() != null) {
            this.setWeekDaysTooltip(i18n.getWeekdays());
        }
        if (i18n.getFirstDayOfWeek() == 0) {
            this.setFirstDayOfWeek(DayOfWeek.SUNDAY);
        } else {
            this.setFirstDayOfWeek(DayOfWeek.of(i18n.getFirstDayOfWeek()));
        }
    }

    public void setWeekDaysShort(List<String> weekdaysShort) {
        Objects.requireNonNull(weekdaysShort);
        for (DayOfWeek day : DayOfWeek.values()) {
            int index = day.getValue() % 7;
            String text = weekdaysShort.get(index);
            this.dayButtons.stream().filter(button -> button.getDayOfWeek() == day).forEach(button -> button.setText(text));
        }
    }

    public void setWeekDaysTooltip(List<String> weekdaysTooltip) {
        Objects.requireNonNull(weekdaysTooltip);
        for (DayOfWeek day : DayOfWeek.values()) {
            int index = day.getValue() % 7;
            String text = weekdaysTooltip.get(index);
            this.dayButtons.stream().filter(button -> button.getDayOfWeek() == day).forEach(button -> button.setTooltipText(text));
        }
    }

    public void setFirstDayOfWeek(DayOfWeek first) {
        DayOfWeekButton[] buttons = (DayOfWeekButton[])this.dayButtons.toArray(DayOfWeekButton[]::new);
        if (buttons[0].dayOfWeek != first) {
            ArrayList<DayOfWeekButton> sortedButtons = new ArrayList<DayOfWeekButton>();
            Arrays.sort(buttons, Comparator.comparing(DayOfWeekButton::getDayOfWeek));
            for (int i = 0; i < buttons.length; ++i) {
                sortedButtons.add(buttons[(i + first.getValue() - 1) % buttons.length]);
            }
            this.setDayButtons(sortedButtons);
        }
    }

    public void setOverflowIcon(Component icon) {
        Objects.requireNonNull(icon, "icon cannot be null");
        this.getElement().getChildren().filter(el -> "overflowIcon".equals(el.getAttribute("slot"))).findFirst().ifPresent(Element::removeFromParent);
        icon.setClassName("overflow-icon");
        icon.getElement().setAttribute("slot", "overflowIcon");
        this.getElement().appendChild(new Element[]{icon.getElement()});
    }

    private void initDefaultDayButtons() {
        this.setDayButtons(List.of(new DayOfWeekButton(DayOfWeek.SUNDAY, "S"), new DayOfWeekButton(DayOfWeek.MONDAY, "M"), new DayOfWeekButton(DayOfWeek.TUESDAY, "T"), new DayOfWeekButton(DayOfWeek.WEDNESDAY, "W"), new DayOfWeekButton(DayOfWeek.THURSDAY, "T"), new DayOfWeekButton(DayOfWeek.FRIDAY, "F"), new DayOfWeekButton(DayOfWeek.SATURDAY, "S")));
    }

    private void setDayButtons(List<DayOfWeekButton> buttons) {
        this.clearDayButtons();
        this.dayButtons = buttons;
        buttons.forEach(button -> button.addClickListener((ComponentEventListener & Serializable)ev -> this.updateValue()));
        this.addDayButtons();
    }

    private void addDayButtons() {
        this.dayButtons.forEach(button -> {
            button.getElement().setAttribute("slot", "daysOfWeek");
            this.getElement().appendChild(new Element[]{button.getElement()});
        });
    }

    private void clearDayButtons() {
        this.dayButtons.forEach(button -> {
            button.getElement().removeAttribute("slot");
            button.removeFromParent();
        });
    }

    private static class DayOfWeekButton
    extends Button {
        private static final String CLASS_NAME = "fc-days-of-week-selector-button";
        private final DayOfWeek dayOfWeek;
        private boolean state;

        public DayOfWeekButton(DayOfWeek dayOfWeek, String text) {
            super(text);
            this.dayOfWeek = dayOfWeek;
            this.setClassName(CLASS_NAME);
            this.addClickListener((ComponentEventListener & Serializable)e -> this.toggleState());
        }

        public DayOfWeek getDayOfWeek() {
            return this.dayOfWeek;
        }

        @ClientCallable
        private void toggleState() {
            this.setState(!this.state);
        }

        private boolean getState() {
            return this.state;
        }

        private void setState(boolean state) {
            this.state = state;
            this.getThemeNames().set(ButtonVariant.LUMO_PRIMARY.getVariantName(), state);
        }
    }

    public static final class CssProperties {
        public static final String OVERFLOW_ICON_SIZE = "--fc-days-of-week-selector-overflow-icon-size";

        private CssProperties() {
        }
    }
}

