/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.dayofweekselector;

import com.flowingcode.vaadin.addons.dayofweekselector.DayOfWeekSelector;
import com.flowingcode.vaadin.addons.dayofweekselector.DayOfWeekSelectorDemoView;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.time.DayOfWeek;
import java.time.format.TextStyle;
import java.util.List;
import java.util.stream.Stream;

@DemoSource
@PageTitle(value="I18N")
@Route(value="day-of-week-selector/i18n", layout=DayOfWeekSelectorDemoView.class)
public class DayOfWeekSelectorI18NDemo
extends Div {
    public DayOfWeekSelectorI18NDemo() {
        DayOfWeekSelector selector = new DayOfWeekSelector();
        selector.setLabel("I18N with DatePickerI18n");
        DatePicker.DatePickerI18n i18n = new DatePicker.DatePickerI18n();
        i18n.setWeekdaysShort(Stream.of(DayOfWeek.values()).map(d -> d.getDisplayName(TextStyle.NARROW_STANDALONE, this.getLocale())).toList());
        i18n.setWeekdays(Stream.of(DayOfWeek.values()).map(d -> d.getDisplayName(TextStyle.FULL_STANDALONE, this.getLocale())).toList());
        i18n.setFirstDayOfWeek(DayOfWeek.MONDAY.getValue() - 1);
        selector.setI18N(i18n);
        this.add(new Component[]{selector});
        selector = new DayOfWeekSelector();
        selector.setLabel("I18N without DatePickerI18n");
        selector.setWeekDaysTooltip(List.of("Domingo", "Lunes", "Martes", "Mi\u00e9rcoles", "Jueves", "Viernes", "S\u00e1bado"));
        selector.setWeekDaysShort(List.of("D", "L", "M", "X", "J", "V", "S"));
        selector.setFirstDayOfWeek(DayOfWeek.MONDAY);
        this.add(new Component[]{selector});
    }
}

