/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.dayofweekselector;

import com.flowingcode.vaadin.addons.dayofweekselector.DayOfWeekSelector;
import com.flowingcode.vaadin.addons.dayofweekselector.DayOfWeekSelectorDemoView;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.theme.lumo.LumoIcon;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

@DemoSource
@PageTitle(value="Demo")
@Route(value="day-of-week-selector/demo", layout=DayOfWeekSelectorDemoView.class)
public class DayOfWeekSelectorDemo
extends VerticalLayout {
    public DayOfWeekSelectorDemo() {
        this.addClassName("demo");
        DayOfWeekSelector selector1 = new DayOfWeekSelector("Enabled", new DayOfWeek[]{DayOfWeek.MONDAY, DayOfWeek.WEDNESDAY});
        selector1.setWidthFull();
        Button updateValueButton = new Button("Set value to SUN-MON-SAT");
        updateValueButton.addClickListener((ComponentEventListener & Serializable)e -> selector1.setValue(DayOfWeek.SUNDAY, new DayOfWeek[]{DayOfWeek.MONDAY, DayOfWeek.FRIDAY, DayOfWeek.SATURDAY}));
        VerticalLayout content = new VerticalLayout(new Component[]{selector1, updateValueButton});
        content.setPadding(false);
        this.add(new Component[]{content});
        DayOfWeekSelector selectorOverflow = new DayOfWeekSelector("Overflow", new DayOfWeek[]{DayOfWeek.MONDAY, DayOfWeek.WEDNESDAY});
        selectorOverflow.setWidth("200px");
        selectorOverflow.setOverflowIcon((Component)LumoIcon.ANGLE_RIGHT.create());
        selectorOverflow.getStyle().set("--fc-days-of-week-selector-overflow-icon-size", "1em");
        Div valueContent = new Div();
        Consumer<Set> valueRenderer = value -> valueContent.setText("Value: " + value.stream().map(Enum::name).collect(Collectors.joining(" - ")));
        this.add(new Component[]{new Div(new Component[]{selectorOverflow, valueContent})});
        valueRenderer.accept((Set)selectorOverflow.getValue());
        selectorOverflow.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> valueRenderer.accept((Set)e.getValue()));
        DayOfWeekSelector selector2 = new DayOfWeekSelector("Read-only", new DayOfWeek[]{DayOfWeek.MONDAY, DayOfWeek.WEDNESDAY});
        selector2.setReadOnly(true);
        this.add(new Component[]{selector2});
        DayOfWeekSelector selector3 = new DayOfWeekSelector("Disabled", new DayOfWeek[]{DayOfWeek.MONDAY, DayOfWeek.WEDNESDAY});
        selector3.setEnabled(false);
        this.add(new Component[]{selector3});
    }
}

