/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.dayofweekselector;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@CssImport(value="./styles/fc-days-of-week-selector-styles.css")
public class DayOfWeekSelector
extends CustomField<Set<DayOfWeek>> {
    private HorizontalLayout buttonsLayout;

    public DayOfWeekSelector() {
        this.getStyle().set("padding", "var(--lumo-space-m)");
        this.setWidthFull();
        this.buttonsLayout = new HorizontalLayout();
        this.buttonsLayout.add(new Component[]{new DayOfWeekButton(DayOfWeek.SUNDAY, "S")});
        this.buttonsLayout.add(new Component[]{new DayOfWeekButton(DayOfWeek.MONDAY, "M")});
        this.buttonsLayout.add(new Component[]{new DayOfWeekButton(DayOfWeek.TUESDAY, "T")});
        this.buttonsLayout.add(new Component[]{new DayOfWeekButton(DayOfWeek.WEDNESDAY, "W")});
        this.buttonsLayout.add(new Component[]{new DayOfWeekButton(DayOfWeek.THURSDAY, "T")});
        this.buttonsLayout.add(new Component[]{new DayOfWeekButton(DayOfWeek.FRIDAY, "F")});
        this.buttonsLayout.add(new Component[]{new DayOfWeekButton(DayOfWeek.SATURDAY, "S")});
        this.buttonsLayout.setClassName("fc-days-of-week-selector-buttons-layout");
        this.getButtons().forEach(button -> button.addClickListener((ComponentEventListener & Serializable)ev -> this.updateValue()));
        this.add(new Component[]{this.buttonsLayout});
        this.clear();
    }

    public DayOfWeekSelector(DayOfWeek ... value) {
        this();
        if (value.length > 0) {
            this.setValue(value[0], value);
        }
    }

    public DayOfWeekSelector(String label) {
        this();
        this.setLabel(label);
    }

    public DayOfWeekSelector(String label, DayOfWeek ... value) {
        this(value);
        this.setLabel(label);
    }

    public Set<DayOfWeek> getEmptyValue() {
        return EnumSet.noneOf(DayOfWeek.class);
    }

    protected boolean valueEquals(Set<DayOfWeek> value1, Set<DayOfWeek> value2) {
        return value1 != value2 && Objects.equals(value1, value2);
    }

    private Stream<DayOfWeekButton> getButtons() {
        return this.buttonsLayout.getChildren().filter(DayOfWeekButton.class::isInstance).map(DayOfWeekButton.class::cast);
    }

    protected Set<DayOfWeek> generateModelValue() {
        return this.getButtons().filter(DayOfWeekButton::getState).map(DayOfWeekButton::getDayOfWeek).collect(Collectors.toCollection(() -> this.getEmptyValue()));
    }

    protected void setPresentationValue(Set<DayOfWeek> newPresentationValue) {
        this.getButtons().forEach(button -> button.setState(newPresentationValue.contains(button.getDayOfWeek())));
    }

    public void setReadOnly(boolean readOnly) {
        this.getElement().setProperty("readonly", readOnly);
        this.getElement().setAttribute("readonly", readOnly);
        this.getButtons().forEach(button -> button.setEnabled(!readOnly));
    }

    public void setValue(DayOfWeek first, DayOfWeek ... rest) {
        this.setValue(EnumSet.of(first, rest));
    }

    public void setI18N(DatePicker.DatePickerI18n i18n) {
        this.setWeekDaysShort(i18n.getWeekdaysShort());
        if (i18n.getFirstDayOfWeek() == 0) {
            this.setFirstDayOfWeek(DayOfWeek.SUNDAY);
        } else {
            this.setFirstDayOfWeek(DayOfWeek.of(i18n.getFirstDayOfWeek()));
        }
    }

    public void setWeekDaysShort(List<String> weekdaysShort) {
        Objects.requireNonNull(weekdaysShort);
        for (DayOfWeek day : DayOfWeek.values()) {
            int index = day.getValue() % 7;
            String text = weekdaysShort.get(index);
            this.getButtons().filter(button -> button.getDayOfWeek() == day).forEach(button -> button.setText(text));
        }
    }

    public void setFirstDayOfWeek(DayOfWeek first) {
        DayOfWeekButton[] buttons = (DayOfWeekButton[])this.getButtons().toArray(DayOfWeekButton[]::new);
        if (buttons[0].dayOfWeek != first) {
            Arrays.sort(buttons, Comparator.comparing(DayOfWeekButton::getDayOfWeek));
            this.buttonsLayout.removeAll();
            for (int i = 0; i < 7; ++i) {
                this.buttonsLayout.add(new Component[]{buttons[(i + first.getValue() - 1) % 7]});
            }
        }
    }

    private static class DayOfWeekButton
    extends Button {
        private static final String CLASS_NAME = "fc-days-of-week-selector-button";
        private final DayOfWeek dayOfWeek;
        private boolean state;

        public DayOfWeekButton(DayOfWeek dayOfWeek, String text) {
            super(text);
            this.dayOfWeek = dayOfWeek;
            this.setClassName(CLASS_NAME);
            this.addClickListener((ComponentEventListener & Serializable)e -> this.toggleState());
        }

        public DayOfWeek getDayOfWeek() {
            return this.dayOfWeek;
        }

        private void toggleState() {
            this.setState(!this.state);
        }

        private boolean getState() {
            return this.state;
        }

        private void setState(boolean state) {
            this.state = state;
            this.getThemeNames().set(ButtonVariant.LUMO_PRIMARY.getVariantName(), state);
        }
    }
}

