/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.cronexpressionfield;

import com.flowingcode.vaadin.addons.cronexpressionfield.CronExpressionFieldI18n;
import com.flowingcode.vaadin.addons.cronexpressionfield.LayoutOptions;
import com.flowingcode.vaadin.addons.dayofweekselector.DayOfWeekSelector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.combobox.ComboBox;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.formlayout.FormLayout;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.component.timepicker.TimePicker;
import com.vaadin.flow.data.provider.BackEndDataProvider;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.internal.JsonSerializer;
import elemental.json.JsonObject;
import it.burning.cron.CronExpressionDescriptor;
import it.burning.cron.CronExpressionParser;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.scheduling.support.CronExpression;

@CssImport(value="./styles/cron-expression-field-styles.css")
public class CronExpressionField
extends CustomField<String> {
    private static final String DEFAULT_CRON = "0 0 0 * * *";
    private Locale locale;
    private String defaultExpression;
    private List<String> commonExpressionsList;
    private final ComboBox<LayoutOptions> cronExpressionLayoutCb = new ComboBox();
    private final VerticalLayout mainLayout = new VerticalLayout();
    private final TextField inputExpressionTf = new TextField();
    private final Div cronDescriptionDiv = new Div();
    private final Grid<LocalDateTime> grid = new Grid();
    private final Button nextDatesBtn = new Button();
    private final ComboBox<String> commonExpressionsCb = new ComboBox();
    private CronExpressionFieldI18n i18n;
    private boolean helpEnabled;
    private boolean commonExpressionsVisible;
    private boolean cronInputEnabled;

    public CronExpressionField() {
        this.setClassName("fc-cron-expression-field");
        this.setI18n(null);
        this.configureLayout();
    }

    public CronExpressionField(String defaultExpression) {
        this();
        this.setDefaultExpression(defaultExpression);
    }

    private void updateCronExpression(Map<Integer, String> cronValues) {
        CharSequence[] cronExpressionSplit = this.inputExpressionTf.getValue().isEmpty() ? DEFAULT_CRON.split(" ") : this.inputExpressionTf.getValue().split(" ");
        for (Integer i : cronValues.keySet()) {
            cronExpressionSplit[i.intValue()] = cronValues.get(i);
        }
        this.inputExpressionTf.setValue(String.join((CharSequence)" ", cronExpressionSplit));
    }

    private void updateCronExpression(String cron) {
        if (this.validateCron(cron)) {
            this.inputExpressionTf.setValue(cron);
            this.updateDescription();
        } else {
            this.cronDescriptionDiv.setText(this.i18n.getDescriptionPlaceholder());
            this.inputExpressionTf.setInvalid(true);
        }
    }

    private void updateDescription() {
        if (this.validateCron(this.inputExpressionTf.getValue())) {
            this.cronDescriptionDiv.setText(CronExpressionDescriptor.getDescription((String)this.inputExpressionTf.getValue(), (CronExpressionParser.Options)new CronExpressionParser.Options(){
                {
                    this.setUseJavaEeScheduleExpression(true);
                    this.setLocale(CronExpressionField.this.locale == null ? Locale.ENGLISH : CronExpressionField.this.locale);
                }
            }));
        }
    }

    private boolean validateCron(String cron) {
        if (cron != null && !cron.isEmpty()) {
            try {
                CronExpressionDescriptor.getDescription((String)cron);
                return CronExpression.isValidExpression((String)cron);
            }
            catch (CronExpressionParser.CronExpressionParseException | IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    private void configureLayout() {
        this.inputExpressionTf.setLabel(this.i18n.getCronExpressionLabel());
        this.inputExpressionTf.setValue(this.defaultExpression == null ? "" : this.defaultExpression);
        Button clearInputBtn = new Button(this.i18n.getClearBtn(), (ComponentEventListener & Serializable)e -> {
            this.inputExpressionTf.setValue(this.defaultExpression == null ? "" : this.defaultExpression);
            this.resetUI();
            this.inputExpressionTf.setInvalid(false);
        });
        this.inputExpressionTf.setSuffixComponent((Component)clearInputBtn);
        this.inputExpressionTf.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> {
            this.updateCronExpression((String)v.getValue());
            this.setModelValue((String)v.getValue(), true);
        });
        this.cronExpressionLayoutCb.setAllowCustomValue(false);
        this.cronExpressionLayoutCb.setItems((Object[])LayoutOptions.values());
        this.cronExpressionLayoutCb.setItemLabelGenerator((ItemLabelGenerator & Serializable)layout -> this.layoutOptionsTranslation((LayoutOptions)((Object)((Object)layout))));
        this.cronExpressionLayoutCb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> {
            switch ((LayoutOptions)((Object)((Object)((Object)v.getValue())))) {
                case MONTHLY: {
                    this.setMonthlyLayout();
                    break;
                }
                case ADVANCED: {
                    this.setAdvancedLayout();
                    break;
                }
                default: {
                    this.setDailyLayout();
                }
            }
        });
        this.cronExpressionLayoutCb.setValue((Object)LayoutOptions.ADVANCED);
        HorizontalLayout topLayout = new HorizontalLayout(new Component[]{this.cronExpressionLayoutCb, this.inputExpressionTf});
        clearInputBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
        this.inputExpressionTf.setSizeFull();
        this.cronExpressionLayoutCb.setWidth("40%");
        this.cronDescriptionDiv.setWidthFull();
        this.cronDescriptionDiv.setClassName("description-div");
        this.addClassNames(new String[]{"justify-center", "items-center", "p-0"});
        this.setMaxWidth("450px");
        this.mainLayout.addClassNames(new String[]{"m-0", "p-0"});
        topLayout.setWidthFull();
        topLayout.setAlignItems(FlexComponent.Alignment.END);
        topLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.BETWEEN);
        if (this.helpEnabled) {
            this.inputExpressionTf.setTooltipText(this.i18n.getInputExpressionTooltip());
        }
        this.nextDatesBtn.setText(this.i18n.getShowNextDatesBtn());
        this.nextDatesBtn.addClickListener((ComponentEventListener & Serializable)e -> this.showNextDates());
        this.nextDatesBtn.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY_INLINE});
        this.nextDatesBtn.setVisible(false);
        this.add(new Component[]{topLayout, this.mainLayout, new Span(this.i18n.getDescriptionLabel()), this.cronDescriptionDiv, this.nextDatesBtn});
        this.resetUI();
    }

    private String layoutOptionsTranslation(LayoutOptions option) {
        return this.i18n.getLayoutOptions().get((Object)option);
    }

    private void resetUI() {
        switch ((LayoutOptions)((Object)this.cronExpressionLayoutCb.getValue())) {
            case MONTHLY: {
                this.setMonthlyLayout();
                break;
            }
            case ADVANCED: {
                this.setAdvancedLayout();
                break;
            }
            default: {
                this.setDailyLayout();
            }
        }
    }

    private void setAdvancedLayout() {
        this.mainLayout.removeAll();
        this.inputExpressionTf.setValue(this.defaultExpression == null ? "" : this.defaultExpression);
        this.inputExpressionTf.setInvalid(false);
        if (this.grid != null) {
            this.remove(new Component[]{this.grid});
        }
        this.inputExpressionTf.setReadOnly(false);
        if (this.commonExpressionsVisible) {
            if (this.commonExpressionsList != null) {
                this.commonExpressionsCb.setItems(this.commonExpressionsList);
            }
            this.commonExpressionsCb.setItemLabelGenerator((ItemLabelGenerator & Serializable)i -> {
                String label = CronExpressionDescriptor.getDescription((String)i, (CronExpressionParser.Options)new CronExpressionParser.Options(){
                    {
                        this.setUseJavaEeScheduleExpression(true);
                        this.setLocale(CronExpressionField.this.locale == null ? Locale.ENGLISH : CronExpressionField.this.locale);
                    }
                });
                return label + " (" + i + ")";
            });
            this.commonExpressionsCb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> this.updateCronExpression((String)this.commonExpressionsCb.getValue()));
            this.commonExpressionsCb.setWidthFull();
            this.commonExpressionsCb.addClassName("self-center");
            this.commonExpressionsCb.setLabel(this.i18n.getCommonExpressionsLabel());
            this.commonExpressionsCb.setAllowCustomValue(false);
            this.mainLayout.add(new Component[]{this.commonExpressionsCb});
        }
    }

    private void setDailyLayout() {
        this.mainLayout.removeAll();
        this.inputExpressionTf.setValue(this.defaultExpression == null ? "" : this.defaultExpression);
        this.inputExpressionTf.setInvalid(false);
        if (this.grid != null) {
            this.remove(new Component[]{this.grid});
        }
        this.inputExpressionTf.setReadOnly(!this.cronInputEnabled);
        TimePicker startsAtTp = new TimePicker(this.i18n.getStartsAtLabel());
        startsAtTp.setStep(Duration.ofMinutes(30L));
        startsAtTp.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> this.getStartsAtExpression((LocalTime)v.getValue()));
        IntegerField timeAmountField = new IntegerField(this.i18n.getRepeatEveryLabel());
        timeAmountField.setMin(0);
        ComboBox timeUnitCb = new ComboBox();
        timeUnitCb.setClassName("inline-combobox");
        timeUnitCb.setWidth("50%");
        timeUnitCb.setItems((Object[])Units.values());
        timeUnitCb.setItemLabelGenerator((ItemLabelGenerator & Serializable)i -> this.i18n.getUnits().get(i));
        timeUnitCb.setValue((Object)Units.SECONDS);
        timeUnitCb.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> {
            if (((Units)((Object)((Object)v.getValue()))).equals((Object)Units.HOURS)) {
                timeAmountField.setMax(23);
            } else {
                timeAmountField.setMax(59);
            }
            if (timeAmountField.getValue() != null && !timeAmountField.isEmpty()) {
                this.getDailyExpression((Units)((Object)((Object)v.getValue())), (Integer)timeAmountField.getValue());
            }
        });
        timeAmountField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> {
            if (!timeAmountField.isInvalid() && !timeAmountField.isEmpty()) {
                this.getDailyExpression((Units)((Object)((Object)timeUnitCb.getValue())), (Integer)v.getValue());
            }
        });
        timeAmountField.addClassName("m-0");
        timeAmountField.setSuffixComponent((Component)timeUnitCb);
        DayOfWeekSelector daySelector = new DayOfWeekSelector();
        daySelector.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> this.getWeeklyExpression((Set)daySelector.getValue()));
        if (this.helpEnabled) {
            timeAmountField.setTooltipText(this.i18n.getTimeAmountTooltip());
            daySelector.setTooltipText(this.i18n.getDaySelectorTooltip());
            startsAtTp.setTooltipText(this.i18n.getStartsAtTooltip());
        }
        FormLayout formLayout = new FormLayout(new Component[]{startsAtTp, timeAmountField});
        formLayout.setResponsiveSteps(new FormLayout.ResponsiveStep[]{new FormLayout.ResponsiveStep("0", 1), new FormLayout.ResponsiveStep("300px", 2)});
        formLayout.setWidthFull();
        this.mainLayout.add(new Component[]{formLayout, daySelector});
    }

    private void setMonthlyLayout() {
        this.mainLayout.removeAll();
        this.inputExpressionTf.setValue(this.defaultExpression == null ? "" : this.defaultExpression);
        this.inputExpressionTf.setInvalid(false);
        if (this.grid != null) {
            this.remove(new Component[]{this.grid});
        }
        this.inputExpressionTf.setReadOnly(!this.cronInputEnabled);
        TimePicker startsAtTp = new TimePicker(this.i18n.getStartsAtLabel());
        startsAtTp.setStep(Duration.ofMinutes(30L));
        startsAtTp.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> this.getStartsAtExpression((LocalTime)v.getValue()));
        startsAtTp.setWidth("35%");
        IntegerField dayOfMonthField = new IntegerField(this.i18n.getDayOfMonthLabel());
        dayOfMonthField.setValue((Number)1);
        dayOfMonthField.setWidth("30%");
        IntegerField monthField = new IntegerField(this.i18n.getRepeatEveryLabel());
        monthField.setSuffixComponent((Component)new Paragraph(this.i18n.getMonth()));
        monthField.setValue((Number)1);
        monthField.setStepButtonsVisible(true);
        monthField.setMin(1);
        monthField.setMax(11);
        monthField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> {
            if (!monthField.isInvalid() && !dayOfMonthField.isInvalid()) {
                this.getMonthlyExpression((Integer)dayOfMonthField.getValue(), (Integer)v.getValue());
            }
        });
        monthField.setWidth("35%");
        dayOfMonthField.addValueChangeListener((HasValue.ValueChangeListener & Serializable)v -> {
            if (!monthField.isInvalid() && !dayOfMonthField.isInvalid()) {
                this.getMonthlyExpression((Integer)v.getValue(), (Integer)monthField.getValue());
            }
        });
        if (this.helpEnabled) {
            dayOfMonthField.setTooltipText(this.i18n.getDayOfMonthTooltip());
            monthField.setTooltipText(this.i18n.getMonthFieldTooltip());
            startsAtTp.setTooltipText(this.i18n.getStartsAtTooltip());
        }
        HorizontalLayout layout = new HorizontalLayout(new Component[]{startsAtTp, dayOfMonthField, monthField});
        layout.setWidthFull();
        layout.setJustifyContentMode(FlexComponent.JustifyContentMode.CENTER);
        this.mainLayout.add(new Component[]{layout});
    }

    private void getStartsAtExpression(LocalTime startsAt) {
        if (this.inputExpressionTf.getValue().isEmpty()) {
            this.updateCronExpression(DEFAULT_CRON);
        }
        if (startsAt != null) {
            HashMap<Integer, String> values = new HashMap<Integer, String>();
            values.put(0, String.valueOf(startsAt.getSecond()));
            values.put(1, String.valueOf(startsAt.getMinute()));
            values.put(2, String.valueOf(startsAt.getHour()));
            this.updateCronExpression(values);
        }
    }

    private void getMonthlyExpression(Integer dayOfMonth, Integer month) {
        if (this.inputExpressionTf.getValue().isEmpty()) {
            this.updateCronExpression(DEFAULT_CRON);
        }
        if (dayOfMonth != null && month != null) {
            HashMap<Integer, String> values = new HashMap<Integer, String>();
            values.put(3, dayOfMonth.toString());
            values.put(4, "1/" + month.toString());
            values.put(5, "?");
            this.updateCronExpression(values);
        }
    }

    private void getWeeklyExpression(Set<DayOfWeek> days) {
        if (this.inputExpressionTf.getValue().isEmpty()) {
            this.updateCronExpression(DEFAULT_CRON);
        }
        HashMap<Integer, String> values = new HashMap<Integer, String>();
        List<String> aux = days.stream().map(d -> String.valueOf(d.getValue())).toList();
        if (days.size() == 7 || days.size() == 0) {
            values.put(5, "*");
        } else {
            values.put(5, String.join((CharSequence)",", aux));
        }
        values.put(3, "?");
        this.updateCronExpression(values);
    }

    private void getDailyExpression(Units timeUnit, int value) {
        HashMap<Integer, String> values = new HashMap<Integer, String>();
        String aux = "*/" + String.valueOf(value);
        if (this.inputExpressionTf.getValue().isEmpty()) {
            this.updateCronExpression(DEFAULT_CRON);
        }
        switch (timeUnit) {
            case SECONDS: {
                values.put(0, aux);
                values.put(1, "0");
                values.put(2, "0");
                break;
            }
            case MINUTES: {
                values.put(0, "0");
                values.put(1, aux);
                values.put(2, "0");
                break;
            }
            case HOURS: {
                values.put(0, "0");
                values.put(1, "0");
                values.put(2, aux);
            }
        }
        this.updateCronExpression(values);
    }

    private void showNextDates() {
        if (!this.inputExpressionTf.getValue().isEmpty()) {
            this.grid.removeAllColumns();
            this.grid.addColumn((ValueProvider & Serializable)date -> this.formatDate((LocalDateTime)date));
            this.grid.setHeight("30%");
            this.grid.setItems((BackEndDataProvider)DataProvider.fromCallbacks((CallbackDataProvider.FetchCallback & Serializable)q -> this.generateNextDate(LocalDateTime.now(), q.getOffset(), q.getLimit()), (CallbackDataProvider.CountCallback & Serializable)q -> Integer.MAX_VALUE));
            this.add(new Component[]{this.grid});
        }
    }

    private LocalDateTime calculateNextDate(LocalDateTime date) {
        return (LocalDateTime)CronExpression.parse((String)this.inputExpressionTf.getValue()).next((Temporal)date);
    }

    private Stream<LocalDateTime> generateNextDate(LocalDateTime start, int offset, int limit) {
        Stream<LocalDateTime> nextDates = Stream.iterate(this.calculateNextDate(start), this::calculateNextDate);
        return nextDates.skip(offset).limit(limit);
    }

    private String formatDate(LocalDateTime date) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.LONG, FormatStyle.MEDIUM).withLocale(this.locale == null ? Locale.ENGLISH : this.locale);
        return date.format(dateFormatter);
    }

    public void setCronInputEnabled(boolean isEnabled) {
        this.cronInputEnabled = isEnabled;
        this.inputExpressionTf.setReadOnly(!isEnabled);
    }

    public void setNextDatesButtonVisible(boolean nextDatesVisible) {
        this.nextDatesBtn.setVisible(nextDatesVisible);
        if (!this.nextDatesBtn.isVisible()) {
            this.remove(new Component[]{this.grid});
        }
    }

    public boolean setDefaultExpression(String cron) {
        if (cron != null && this.validateCron(cron)) {
            this.defaultExpression = cron;
            return true;
        }
        return false;
    }

    public boolean addCommonExpressions(String ... crons) {
        if (this.commonExpressionsList == null) {
            this.commonExpressionsList = new ArrayList<String>();
        }
        for (String cron : crons) {
            if (!this.validateCron(cron)) {
                return false;
            }
            this.commonExpressionsList.add(cron);
        }
        this.commonExpressionsCb.setItems(this.commonExpressionsList);
        return true;
    }

    public void setCommonExpressionsVisible(boolean commonExpressionsVisible) {
        this.commonExpressionsVisible = commonExpressionsVisible;
        this.resetUI();
    }

    public void setHelpEnabled(boolean helpEnabled) {
        this.helpEnabled = helpEnabled;
        this.resetUI();
    }

    protected String generateModelValue() {
        return this.inputExpressionTf.getValue().isEmpty() ? null : this.inputExpressionTf.getValue();
    }

    protected void setPresentationValue(String newPresentationValue) {
        this.inputExpressionTf.setValue(newPresentationValue);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setI18n(CronExpressionFieldI18n i18n) {
        this.i18n = i18n != null ? i18n : CronExpressionFieldI18n.createDefault();
        this.getUI().ifPresent(ui -> this.setI18nWithJS());
    }

    private void setI18nWithJS() {
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            JsonObject i18nObject = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
            for (String key : i18nObject.keys()) {
                this.getElement().executeJs("this.set('i18n." + key + "', $0)", new Serializable[]{i18nObject.get(key)});
            }
        });
    }

    private void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    protected static enum Units {
        SECONDS,
        MINUTES,
        HOURS;

    }
}

