/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chipfield;

import com.flowingcode.vaadin.addons.chipfield.ChipField;
import com.flowingcode.vaadin.addons.chipfield.ChipfieldDemoView;
import com.flowingcode.vaadin.addons.chipfield.Planet;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.stream.Collectors;

@Route(value="chipfield/dataprovider", layout=ChipfieldDemoView.class)
@PageTitle(value="Data Provider")
@DemoSource
public class DataProviderDemo
extends VerticalLayout {
    public DataProviderDemo() {
        ListDataProvider ldp = new ListDataProvider(Planet.all());
        ChipField chf = new ChipField("Select some planets (Mercury, Venus, Earth, etc.)", (ItemLabelGenerator & Serializable)planet -> planet.getName(), (Object[])new Planet[0]);
        chf.setWidthFull();
        chf.setDataProvider((DataProvider)ldp);
        chf.setClosable(true);
        chf.setNewItemHandler((SerializableFunction & Serializable)label -> new Planet((String)label));
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.add(new Component[]{new Button("Obtain selected planets", (ComponentEventListener & Serializable)ev -> Notification.show((String)("Planets: " + chf.getValue().stream().map(Planet::getName).collect(Collectors.joining(","))), (int)5000, (Notification.Position)Notification.Position.BOTTOM_START))});
        buttons.add(new Component[]{new Button("Add random planet", (ComponentEventListener & Serializable)ev -> {
            Planet newPlanet = Planet.random();
            ldp.getItems().add(newPlanet);
            ldp.refreshAll();
            chf.addSelectedItem((Object)newPlanet);
        })});
        chf.addChipCreatedListener((ComponentEventListener & Serializable)ev -> Notification.show((String)("Chip: " + ev.getItem() + " Created by client: " + ev.isFromClient() + "!"), (int)5000, (Notification.Position)Notification.Position.BOTTOM_START));
        chf.addChipRemovedListener((ComponentEventListener & Serializable)ev -> Notification.show((String)("Chip: " + ev.getItem() + " Removed by client: " + ev.isFromClient() + "!"), (int)5000, (Notification.Position)Notification.Position.BOTTOM_START));
        chf.addChipClickedListener((ComponentEventListener & Serializable)ev -> Notification.show((String)("Chip: " + ev.getItem() + " Clicked!"), (int)5000, (Notification.Position)Notification.Position.BOTTOM_END));
        buttons.add(new Component[]{new Button("All planets", (ComponentEventListener & Serializable)ev -> chf.setValue(Planet.all()))});
        buttons.add(new Component[]{new Button("Remove Inner planets", (ComponentEventListener & Serializable)ev -> {
            chf.removeSelectedItem((Object)new Planet("Mercury"));
            chf.removeSelectedItem((Object)new Planet("Venus"));
            chf.removeSelectedItem((Object)new Planet("Earth"));
            chf.removeSelectedItem((Object)new Planet("Mars"));
        })});
        this.add(new Component[]{new VerticalLayout(new Component[]{chf, buttons})});
    }
}

