/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chipfield;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.data.binder.HasDataProvider;
import com.vaadin.flow.data.binder.HasItemsAndComponents;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import elemental.json.impl.JreJsonFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;

@Tag(value="paper-chip-input-autocomplete")
@NpmPackage.Container(value={@NpmPackage(value="@polymer/iron-a11y-keys", version="3.0.1"), @NpmPackage(value="@polymer/iron-a11y-keys-behavior", version="3.0.1"), @NpmPackage(value="@polymer/iron-icons", version="3.0.1"), @NpmPackage(value="@polymer/paper-icon-button", version="3.0.2"), @NpmPackage(value="@polymer/paper-input", version="3.0.1"), @NpmPackage(value="@polymer/paper-item", version="3.0.1"), @NpmPackage(value="@polymer/paper-listbox", version="3.0.1"), @NpmPackage(value="@polymer/paper-material", version="3.0.1"), @NpmPackage(value="@polymer/paper-ripple", version="3.0.1"), @NpmPackage(value="@polymer/paper-styles", version="3.0.1")})
@JsModule(value="./paper-chip-input-autocomplete.js")
public class ChipField<T>
extends AbstractField<ChipField<T>, List<T>>
implements HasStyle,
HasItemsAndComponents<T>,
HasDataProvider<T>,
HasSize,
HasTheme {
    public static final String CHIP_LABEL = "event.detail.chipLabel";
    private DataProvider<T, ?> availableItems = DataProvider.ofCollection(new ArrayList());
    private List<T> additionalItems = new ArrayList<T>();
    private ItemLabelGenerator<T> itemLabelGenerator;
    private SerializableFunction<String, T> newItemHandler;

    @SafeVarargs
    public ChipField(String label, ItemLabelGenerator<T> itemLabelGenerator, T ... availableItems) {
        super(new ArrayList());
        this.setChipLabelGenerator(itemLabelGenerator);
        this.setLabel(label);
        this.availableItems = DataProvider.ofCollection(Arrays.asList(availableItems));
        this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> {
            for (Object t : (List)ev.getOldValue()) {
                if (((List)ev.getValue()).contains(t)) continue;
                this.fireEvent(new ChipRemovedEvent(this, ev.isFromClient(), t));
            }
            for (Object t : (List)ev.getValue()) {
                if (((List)ev.getOldValue()).contains(t)) continue;
                this.fireEvent(new ChipCreatedEvent(this, ev.isFromClient(), t));
            }
        });
    }

    @SafeVarargs
    public ChipField(String label, T ... availableItems) {
        this(label, (ItemLabelGenerator<T>)((ItemLabelGenerator & Serializable)Object::toString), availableItems);
    }

    private void configure() {
        this.configureItems();
        this.getElement().addEventListener("chip-created", (DomEventListener & Serializable)e -> {
            JsonObject eventData = e.getEventData();
            String chipLabel = eventData.get(CHIP_LABEL).asString();
            Object newItem = this.findItemByLabel(chipLabel).orElseGet(() -> {
                if (this.isAllowAdditionalItems()) {
                    if (this.newItemHandler == null) {
                        this.setPresentationValue((List)this.getValue());
                        throw new IllegalStateException("You need to setup a NewItemHandler");
                    }
                    return this.newItemHandler.apply((Object)chipLabel);
                }
                this.setPresentationValue((List)this.getValue());
                throw new IllegalStateException("Adding new items is not allowed, but still receiving new items (not present in DataProvider) from client-side. Probably wrong configuration.");
            });
            this.addSelectedItem(newItem, true);
        }).addEventData(CHIP_LABEL);
        this.getElement().addEventListener("chip-removed", (DomEventListener & Serializable)e -> {
            JsonObject eventData = e.getEventData();
            String chipLabel = eventData.get(CHIP_LABEL).asString();
            this.findItemByLabel(chipLabel).ifPresent(item -> this.removeSelectedItem(item, true));
        }).addEventData(CHIP_LABEL);
        this.getElement().addEventListener("chip-clicked", (DomEventListener & Serializable)e -> {}).addEventData(CHIP_LABEL);
    }

    private void configureItems() {
        Stream streamItems = this.availableItems.fetch(new Query());
        JsonArray array = new JreJsonFactory().createArray();
        AtomicInteger index = new AtomicInteger(0);
        streamItems.forEach(item -> {
            JsonObject object = new JreJsonFactory().createObject();
            object.put("text", this.itemLabelGenerator.apply(item));
            object.put("value", this.itemLabelGenerator.apply(item));
            array.set(index.getAndIncrement(), (JsonValue)object);
        });
        this.getElement().setPropertyJson("source", (JsonValue)array);
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.configure();
        this.setPresentationValue((List<T>)this.getValue());
    }

    public List<T> getValue() {
        return new ArrayList((Collection)super.getValue());
    }

    protected void setPresentationValue(List<T> newPresentationValue) {
        ArrayList<String> labels = new ArrayList<String>();
        if (this.isAllowAdditionalItems()) {
            for (T item : newPresentationValue) {
                String label = this.itemLabelGenerator.apply(item);
                if (!this.findItemByLabel(label).isPresent()) {
                    this.addSelectedItemInternal(item, false);
                    this.additionalItems.add(item);
                }
                labels.add(label);
            }
        } else {
            boolean hasChanges = false;
            newPresentationValue = new ArrayList<T>(newPresentationValue);
            Iterator<T> it = newPresentationValue.iterator();
            while (it.hasNext()) {
                T item = it.next();
                String label = this.itemLabelGenerator.apply(item);
                if (this.findItemByLabel(label).isPresent()) {
                    labels.add(label);
                    continue;
                }
                it.remove();
                hasChanges = true;
            }
            if (hasChanges) {
                this.setModelValue(newPresentationValue, false);
            }
        }
        this.setClientChipWithoutEvent(labels.toArray(new String[labels.size()]));
    }

    private Optional<T> findItemByLabel(String label) {
        return Stream.concat(this.availableItems.fetch(new Query()), this.additionalItems.stream()).filter(item -> this.itemLabelGenerator.apply(item).equals(label)).findFirst();
    }

    private void setClientChipWithoutEvent(String[] labels) {
        this.getElement().executeJs("this.splice('items', 0, this.items.length);", new Serializable[0]);
        for (String label : labels) {
            this.getElement().executeJs("this.push('items', $0);", new Serializable[]{label});
        }
        this.getElement().executeJs("this.required = false; this.autoValidate = false; this._value = '';", new Serializable[0]);
    }

    public void setAvailableItems(List<T> items) {
        this.availableItems = DataProvider.ofCollection(items);
    }

    public String getLabel() {
        return this.getElement().getProperty("label");
    }

    public void setLabel(String label) {
        this.getElement().setProperty("label", label);
    }

    public String[] getChipsAsStrings() {
        return (String[])((List)super.getValue()).stream().map(this.itemLabelGenerator).toArray(String[]::new);
    }

    public void setClosable(boolean closable) {
        this.getElement().setProperty("closable", closable);
    }

    public boolean isClosable() {
        return this.getElement().getProperty("closable", false);
    }

    @Deprecated
    public void setDisabled(boolean disabled) {
        this.getElement().setProperty("disabled", disabled);
    }

    @Deprecated
    public boolean isDisabled() {
        return this.getElement().getProperty("disabled", false);
    }

    @Deprecated
    public void setReadonly(boolean readonly) {
        this.setReadOnly(readonly);
    }

    @Deprecated
    public boolean isReadonly() {
        return this.isReadonly();
    }

    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        this.getElement().callJsFunction("toggleReadonly", new Serializable[0]);
    }

    @Deprecated
    public void setRequired(boolean required) {
        this.getElement().setProperty("required", required);
    }

    @Deprecated
    public boolean isRequired() {
        return this.isRequiredIndicatorVisible();
    }

    public void setValidationPattern(String pattern) {
        this.getElement().setProperty("pattern", pattern);
    }

    public String getValidationPattern() {
        return this.getElement().getProperty("pattern");
    }

    public void setValidationErrorMessage(String errorMessage) {
        this.getElement().setProperty("errorMessage", errorMessage);
    }

    public String getValidationErrorMessage() {
        return this.getElement().getProperty("errorMessage");
    }

    public void setAllowedPattern(String pattern) {
        this.getElement().setProperty("allowedPattern", pattern);
    }

    public String getAllowedPattern() {
        return this.getElement().getProperty("allowedPattern");
    }

    public void setAllowAdditionalItems(boolean allowAdditionalItems) {
        this.getElement().setProperty("additionalItems", allowAdditionalItems);
    }

    public boolean isAllowAdditionalItems() {
        return this.getElement().getProperty("additionalItems", false);
    }

    public void validate() {
        this.getElement().callJsFunction("validate", new Serializable[0]);
    }

    public Registration addChipRemovedListener(ComponentEventListener<ChipRemovedEvent<T>> listener) {
        return this.addListener(ChipRemovedEvent.class, listener);
    }

    public Registration addChipCreatedListener(ComponentEventListener<ChipCreatedEvent<T>> listener) {
        return this.addListener(ChipCreatedEvent.class, listener);
    }

    public void setChipLabelGenerator(ItemLabelGenerator<T> itemLabelGenerator) {
        Objects.requireNonNull(itemLabelGenerator, "The item label generator can not be null");
        this.itemLabelGenerator = itemLabelGenerator;
        this.configureItems();
        this.refreshChipsLabel();
    }

    public void setNewItemHandler(SerializableFunction<String, T> handler) {
        this.newItemHandler = handler;
        this.setAllowAdditionalItems(true);
    }

    public void setDataProvider(DataProvider<T, ?> dataProvider) {
        this.availableItems = dataProvider;
    }

    public void addSelectedItem(T newItem) {
        this.addSelectedItem(newItem, false);
    }

    private void addSelectedItem(T newItem, boolean fromClient) {
        String label = this.itemLabelGenerator.apply(newItem);
        if (this.isAllowAdditionalItems()) {
            this.addSelectedItemInternal(this.findItemByLabel(label).orElseGet(() -> {
                this.additionalItems.add(newItem);
                return newItem;
            }), fromClient);
        } else {
            this.addSelectedItemInternal(this.findItemByLabel(label).orElseThrow(() -> new UnsupportedOperationException("Cannot select item '" + newItem + "', because is not present in DataProvider, and adding new items is not permitted.")), fromClient);
        }
    }

    private void addSelectedItemInternal(T newItem, boolean fromClient) {
        ArrayList<T> value = this.getValue();
        if (!value.contains(newItem)) {
            value = new ArrayList<T>(value);
            value.add(newItem);
            this.setModelValue(value, fromClient);
            if (!fromClient) {
                this.setPresentationValue(value);
            }
        }
    }

    public void removeSelectedItem(T itemToRemove) {
        this.removeSelectedItem(itemToRemove, false);
    }

    private void removeSelectedItem(T itemToRemove, boolean fromClient) {
        ArrayList value = new ArrayList(this.getValue());
        if (value.remove(itemToRemove)) {
            this.additionalItems.retainAll(value);
            this.setModelValue(value, fromClient);
            if (!fromClient) {
                this.setPresentationValue(value);
            }
        }
    }

    public Registration addChipClickedListener(ComponentEventListener<ChipClickedEvent<T>> listener) {
        return this.addListener(ChipClickedEvent.class, listener);
    }

    private void refreshChipsLabel() {
        String[] labels = (String[])this.getValue().stream().map(arg_0 -> this.itemLabelGenerator.apply(arg_0)).toArray(String[]::new);
        this.setClientChipWithoutEvent(labels);
    }

    @DomEvent(value="chip-clicked")
    public static class ChipClickedEvent<T>
    extends ChipEvent<T> {
        public ChipClickedEvent(ChipField<T> source, boolean fromClient, @EventData(value="event.detail.chipLabel") String chipLabel) {
            super(source, fromClient, chipLabel);
        }
    }

    public static class ChipCreatedEvent<T>
    extends ChipEvent<T> {
        public ChipCreatedEvent(ChipField<T> source, boolean fromClient, T item) {
            super(source, fromClient, item, ((ChipField)source).itemLabelGenerator.apply(item));
        }
    }

    public static class ChipRemovedEvent<T>
    extends ChipEvent<T> {
        public ChipRemovedEvent(ChipField<T> source, boolean fromClient, T item) {
            super(source, fromClient, item, ((ChipField)source).itemLabelGenerator.apply(item));
        }
    }

    public static abstract class ChipEvent<T>
    extends ComponentEvent<ChipField<T>> {
        private final String chipLabel;
        private final T item;

        private ChipEvent(ChipField<T> source, boolean fromClient, T item, String chipLabel) {
            super(source, fromClient);
            this.chipLabel = chipLabel;
            this.item = item;
        }

        public ChipEvent(ChipField<T> source, boolean fromClient, String chipLabel) {
            this(source, fromClient, ((ChipField)source).findItemByLabel(chipLabel).orElse(null), chipLabel);
        }

        public String getChipLabel() {
            return this.chipLabel;
        }

        public T getItem() {
            return this.item;
        }
    }
}

