/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chipfield;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Planet {
    private String name;
    private List<String> features;

    public Planet(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Planet other = (Planet)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static List<Planet> all() {
        return Stream.of("Mercury", "Venus", "Earth", "Mars", "Jupiter", "Saturn", "Uranus", "Neptune").map(Planet::new).collect(Collectors.toList());
    }

    public static Planet random() {
        return new Planet("Planet " + Integer.toString((int)Math.round(Math.random() * 36.0 * 36.0 * 36.0), 36).toUpperCase());
    }

    public String toString() {
        return this.name;
    }
}

