/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chipfield.integration.rpc;

import com.flowingcode.vaadin.addons.chipfield.integration.rpc.JreJsonArrayList;
import com.flowingcode.vaadin.addons.chipfield.integration.rpc.TestbenchJsonArrayList;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public interface JsonArrayList<T>
extends JsonValue,
Collection<T> {
    public List<T> asList();

    public static JsonArrayList<String> fromStringArray(List<String> list) {
        return JsonArrayList.createArray(list, Json::create);
    }

    public static JsonArrayList<Boolean> fromBooleanArray(List<Boolean> list) {
        return JsonArrayList.createArray(list, Json::create);
    }

    public static JsonArrayList<Double> fromDoubleArray(List<Double> list) {
        return JsonArrayList.createArray(list, Json::create);
    }

    public static <T> JsonArrayList<T> createArray(List<T> list, Function<? super T, JsonValue> mapper) {
        return new JreJsonArrayList<T>(list, mapper);
    }

    public static <T> JsonArrayList<T> wrapForTestbench(List<T> list) {
        return new TestbenchJsonArrayList<T>(list);
    }
}

