/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chipfield.integration.rpc;

import com.flowingcode.vaadin.addons.chipfield.integration.rpc.JsonArrayList;
import com.vaadin.testbench.HasDriver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebElement;

public interface HasRpcSupport
extends HasDriver {
    default public Object call(String callable, Object ... arguments) {
        WebElement view = this.getDriver().findElement(By.id((String)"view"));
        arguments = Optional.ofNullable(arguments).orElse(new Object[0]);
        StringBuilder script = new StringBuilder();
        script.append("var view = arguments[0];");
        script.append("var callable = arguments[1];");
        script.append("var callback = (result,success) => arguments[3]({result, success});");
        script.append("view.$server[callable](...arguments[2])");
        script.append(" .then(result=>callback(result, true))");
        script.append(" .catch(()=>callback(undefined, false));");
        Map result = (Map)((JavascriptExecutor)this.getDriver()).executeAsyncScript(script.toString(), new Object[]{view, callable, arguments});
        if (!((Boolean)result.get("success")).booleanValue()) {
            throw new RuntimeException(String.format("server call failed: %s(%s)", callable, Stream.of(arguments).map(Object::toString).collect(Collectors.joining(","))));
        }
        return result.get("result");
    }

    default public <T> T createCallableProxy(Class<T> intf) {
        return intf.cast(Proxy.newProxyInstance(intf.getClassLoader(), new Class[]{intf}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Object result = HasRpcSupport.this.call(method.getName(), args);
                Class returnType = method.getReturnType();
                if (result == null || returnType == Void.TYPE) {
                    return null;
                }
                if (returnType == JsonArrayList.class) {
                    return JsonArrayList.wrapForTestbench((List)result);
                }
                if (returnType.isPrimitive()) {
                    returnType = ClassUtils.primitiveToWrapper(method.getReturnType());
                }
                if (returnType.isInstance(result)) {
                    return result;
                }
                throw new ClassCastException(String.format("%s as %s", result.getClass().getName(), method.getReturnType().getName()));
            }
        }));
    }
}

