/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chipfield;

import com.flowingcode.vaadin.addons.chipfield.ChipField;
import com.flowingcode.vaadin.addons.chipfield.Planet;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.Binder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BinderDemo
extends VerticalLayout {
    public BinderDemo() {
        Planet p = new Planet("A new planet");
        ChipField chf = new ChipField("Choose planet features (try with: 'Rings', 'Moons', 'Water', etc.)", (Object[])new String[0]);
        chf.setWidthFull();
        List<String> items = Arrays.asList("Rings", "Moons", "Water", "Rocks", "Lava", "Ice", "Cold", "Heat", "Atmosphere");
        chf.setItems(items);
        Binder binder = new Binder();
        binder.bind((HasValue)chf, Planet::getFeatures, Planet::setFeatures);
        binder.setBean((Object)p);
        chf.addValueChangeListener((HasValue.ValueChangeListener & Serializable)newItem -> Notification.show((String)("Current value: " + newItem.getValue()), (int)5000, (Notification.Position)Notification.Position.BOTTOM_START));
        this.add(new Component[]{chf});
        this.add(new Component[]{new Button("Show planet features", (ComponentEventListener & Serializable)e -> Notification.show((String)("Features: " + p.getFeatures()), (int)5000, (Notification.Position)Notification.Position.BOTTOM_START))});
        this.add(new Component[]{new Button("Random features", (ComponentEventListener & Serializable)ev -> {
            p.setFeatures(items.stream().filter(x -> Math.random() > 0.7).collect(Collectors.toList()));
            binder.setBean((Object)p);
        })});
    }
}

