/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chipfield;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.dom.Element;

@Tag(value="paper-chip")
@NpmPackage.Container(value={@NpmPackage(value="@polymer/iron-a11y-keys", version="^3.0.1"), @NpmPackage(value="@polymer/iron-a11y-keys-behavior", version="^3.0.1"), @NpmPackage(value="@polymer/iron-icons", version="^3.0.1"), @NpmPackage(value="@polymer/paper-icon-button", version="^3.0.2"), @NpmPackage(value="@polymer/paper-input", version="^3.0.1"), @NpmPackage(value="@polymer/paper-item", version="^3.0.1"), @NpmPackage(value="@polymer/paper-listbox", version="^3.0.1"), @NpmPackage(value="@polymer/paper-material", version="^3.0.1"), @NpmPackage(value="@polymer/paper-ripple", version="^3.0.1"), @NpmPackage(value="@polymer/paper-styles", version="^3.0.1")})
@JavaScript(value="./paper-chip.js")
public class Chip
extends Component {
    public static final String CHIP_LABEL = "event.detail.chipLabel";
    private String label;
    private boolean closable;
    private Icon icon;

    public Chip(String label, boolean closable, Icon icon) {
        this.setLabel(label);
        this.setClosable(closable);
        this.setIcon(icon);
    }

    public Chip(String chipText) {
        this(chipText, true, null);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.getElement().setAttribute("label", label);
        this.label = label;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public void setClosable(boolean closable) {
        if (closable) {
            this.getElement().setAttribute("closable", closable);
        }
        this.closable = closable;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        if (icon != null) {
            Span s = new Span();
            s.setClassName("chip-background");
            s.getElement().setAttribute("slot", "avatar");
            s.add(new Component[]{icon});
            this.getElement().appendChild(new Element[]{s.getElement()});
        }
        this.icon = icon;
    }
}

