/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chipfield;

import com.flowingcode.vaadin.addons.chipfield.ChipField;
import com.flowingcode.vaadin.addons.chipfield.Planet;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ItemLabelGenerator;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.function.SerializableFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DataProviderDemo
extends VerticalLayout {
    public DataProviderDemo() {
        ArrayList<Planet> availablePlanets = new ArrayList<Planet>(Arrays.asList(new Planet("Mercury"), new Planet("Venus"), new Planet("Earth"), new Planet("Mars"), new Planet("Jupiter"), new Planet("Saturn"), new Planet("Uranus"), new Planet("Neptune")));
        ListDataProvider ldp = new ListDataProvider(availablePlanets);
        ChipField chf = new ChipField("Select some planets (Mercury, Venus, Earth, etc.)", (ItemLabelGenerator & Serializable)planet -> planet.getName(), (Object[])new Planet[0]);
        chf.setWidthFull();
        chf.setDataProvider((DataProvider)ldp);
        chf.setClosable(true);
        chf.setNewItemHandler((SerializableFunction & Serializable)label -> new Planet((String)label));
        Button b = new Button("Obtain selected planets");
        b.addClickListener((ComponentEventListener & Serializable)event -> Notification.show((String)("Planets: " + ((List)chf.getValue()).stream().map(planet -> planet.getName()).collect(Collectors.joining(","))), (int)5000, (Notification.Position)Notification.Position.BOTTOM_START));
        Button b2 = new Button("Add random planet");
        b2.addClickListener((ComponentEventListener & Serializable)event -> {
            Planet p = new Planet("Planet" + Math.round(Math.random() * 10000.0));
            availablePlanets.add(p);
            ldp.refreshAll();
            chf.addSelectedItem((Object)p);
        });
        chf.addChipCreatedListener((ComponentEventListener & Serializable)ev -> Notification.show((String)("Chip: " + ev.getChipLabel() + " Created by client: " + ev.isFromClient() + "!"), (int)5000, (Notification.Position)Notification.Position.BOTTOM_START));
        chf.addChipRemovedListener((ComponentEventListener & Serializable)ev -> Notification.show((String)("Chip: " + ev.getChipLabel() + " Removed by client: " + ev.isFromClient() + "!"), (int)5000, (Notification.Position)Notification.Position.BOTTOM_START));
        chf.addChipClickedListener((ComponentEventListener & Serializable)ev -> Notification.show((String)("Chip: " + ev.getChipLabel() + " Clicked!"), (int)5000, (Notification.Position)Notification.Position.BOTTOM_END));
        VerticalLayout vl = new VerticalLayout(new Component[]{chf, new HorizontalLayout(new Component[]{b, b2})});
        this.add(new Component[]{vl});
    }
}

