/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chipfield;

import com.flowingcode.vaadin.addons.DemoLayout;
import com.flowingcode.vaadin.addons.GithubLink;
import com.flowingcode.vaadin.addons.chipfield.BinderDemo;
import com.flowingcode.vaadin.addons.chipfield.DataProviderDemo;
import com.flowingcode.vaadin.addons.chipfield.DisabledDemo;
import com.flowingcode.vaadin.addons.chipfield.RestrictedDemo;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.IFrame;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.splitlayout.SplitLayout;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@StyleSheet(value="context://frontend/styles/demo-styles.css")
@Route(value="chipfield", layout=DemoLayout.class)
@GithubLink(value="https://github.com/FlowingCode/ChipFieldAddon")
public class ChipfieldDemoView
extends VerticalLayout {
    private static final String DATAPROVIDER_DEMO = "Data Provider";
    private static final String RESTRICTED_DEMO = "Restricted";
    private static final String DISABLED_DEMO = "Disabled";
    private static final String BINDER_DEMO = "Binder";
    private static final String DATAPROVIDER_SOURCE = "https://github.com/FlowingCode/ChipFieldAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/chipfield/DataProviderDemo.java";
    private static final String RESTRICTED_SOURCE = "https://github.com/FlowingCode/ChipFieldAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/chipfield/RestrictedDemo.java";
    private static final String DISABLED_SOURCE = "https://github.com/FlowingCode/ChipFieldAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/chipfield/DisabledDemo.java";
    private static final String BINDER_SOURCE = "https://github.com/FlowingCode/ChipFieldAddon/blob/master/src/test/java/com/flowingcode/vaadin/addons/chipfield/BinderDemo.java";

    public ChipfieldDemoView() {
        SplitLayout layout = new SplitLayout();
        layout.setOrientation(SplitLayout.Orientation.HORIZONTAL);
        layout.addToPrimary(new Component[]{new DataProviderDemo()});
        layout.setSizeFull();
        IFrame iframe = new IFrame();
        iframe.getElement().setAttribute("frameborder", "0");
        iframe.setMinHeight("0");
        iframe.setMinWidth("0");
        iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(DATAPROVIDER_SOURCE));
        iframe.setSizeFull();
        layout.addToSecondary(new Component[]{iframe});
        Tabs tabs = new Tabs();
        Tab demo1 = new Tab(DATAPROVIDER_DEMO);
        Tab demo2 = new Tab(RESTRICTED_DEMO);
        Tab demo3 = new Tab(DISABLED_DEMO);
        Tab demo4 = new Tab(BINDER_DEMO);
        tabs.setWidthFull();
        tabs.add(new Tab[]{demo1, demo2, demo3, demo4});
        Checkbox orientationCB = new Checkbox("Toggle Orientation");
        orientationCB.setValue((Object)true);
        orientationCB.addClassName("smallcheckbox");
        orientationCB.addValueChangeListener((HasValue.ValueChangeListener & Serializable)cb -> {
            if (((Boolean)cb.getValue()).booleanValue()) {
                layout.setOrientation(SplitLayout.Orientation.HORIZONTAL);
            } else {
                layout.setOrientation(SplitLayout.Orientation.VERTICAL);
            }
            layout.getPrimaryComponent().getElement().setAttribute("style", "width: 100%; height: 100%");
            iframe.setSizeFull();
        });
        Checkbox codeCB = new Checkbox("Show Source Code");
        codeCB.setValue((Object)true);
        codeCB.addClassName("smallcheckbox");
        codeCB.addValueChangeListener((HasValue.ValueChangeListener & Serializable)cb -> {
            if (((Boolean)cb.getValue()).booleanValue()) {
                layout.setSplitterPosition(50.0);
                orientationCB.setEnabled(true);
            } else {
                layout.setSplitterPosition(100.0);
                orientationCB.setEnabled(false);
            }
        });
        HorizontalLayout footer = new HorizontalLayout();
        footer.setWidthFull();
        footer.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        footer.add(new Component[]{codeCB, orientationCB});
        this.add(new Component[]{tabs, layout, footer});
        this.setSizeFull();
        tabs.addSelectedChangeListener((ComponentEventListener & Serializable)e -> {
            this.removeAll();
            switch (e.getSelectedTab().getLabel()) {
                case "Data Provider": {
                    iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(DATAPROVIDER_SOURCE));
                    layout.addToPrimary(new Component[]{new DataProviderDemo()});
                    layout.addToSecondary(new Component[]{iframe});
                    this.add(new Component[]{tabs, layout, footer});
                    break;
                }
                case "Restricted": {
                    iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(RESTRICTED_SOURCE));
                    layout.addToPrimary(new Component[]{new RestrictedDemo()});
                    layout.addToSecondary(new Component[]{iframe});
                    this.add(new Component[]{tabs, layout, footer});
                    break;
                }
                case "Disabled": {
                    iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(DISABLED_SOURCE));
                    layout.addToPrimary(new Component[]{new DisabledDemo()});
                    layout.addToSecondary(new Component[]{iframe});
                    this.add(new Component[]{tabs, layout, footer});
                    break;
                }
                case "Binder": {
                    iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(BINDER_SOURCE));
                    layout.addToPrimary(new Component[]{new BinderDemo()});
                    layout.addToSecondary(new Component[]{iframe});
                    this.add(new Component[]{tabs, layout, footer});
                    break;
                }
                default: {
                    iframe.getElement().setAttribute("srcdoc", this.getSrcdoc(DATAPROVIDER_SOURCE));
                    layout.addToPrimary(new Component[]{new DataProviderDemo()});
                    layout.addToSecondary(new Component[]{iframe});
                    this.add(new Component[]{tabs, layout, footer});
                }
            }
        });
    }

    private String getSrcdoc(String sourceUrl) {
        return "<html style=\"overflow-y:hidden; height:100%;\"><body style=\"overflow-y: scroll; height:100%;\"><script src=\"https://gist-it.appspot.com/" + sourceUrl + "\"></script></body></html>";
    }
}

