/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.chipfield;

import com.flowingcode.vaadin.addons.chipfield.ChipField;
import com.flowingcode.vaadin.addons.chipfield.Planet;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.Binder;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;

public class BinderDemo
extends VerticalLayout {
    public BinderDemo() {
        Planet p = new Planet("A new planet");
        ChipField chf = new ChipField("Choose planet features (Binder demo, try with: 'Rings', 'Moons', 'Water', etc.)", (Object[])new String[0]);
        chf.setWidthFull();
        chf.setItems(Arrays.asList("Rings", "Moons", "Water", "Rocks", "Lava", "Ice", "Cold", "Heat", "Atmosphere"));
        Binder binder = new Binder();
        binder.bind((HasValue)chf, Planet::getConfiguration, Planet::setConfiguration);
        binder.setBean((Object)p);
        Button show = new Button("Show planet configuration");
        show.addClickListener((ComponentEventListener & Serializable)event -> Notification.show((String)("Planet: " + p.getName() + ", features: " + p.getConfiguration().stream().collect(Collectors.joining(","))), (int)5000, (Notification.Position)Notification.Position.BOTTOM_START));
        chf.addValueChangeListener((HasValue.ValueChangeListener & Serializable)newItem -> Notification.show((String)("Items: " + newItem.getValue()), (int)5000, (Notification.Position)Notification.Position.BOTTOM_START));
        this.add(new Component[]{chf, show});
    }
}

