/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.badgelist;

import com.flowingcode.vaadin.addons.badgelist.Badge;
import com.flowingcode.vaadin.addons.badgelist.BadgeList;
import com.flowingcode.vaadin.addons.badgelist.BadgeListDemoView;
import com.flowingcode.vaadin.addons.badgelist.BaseBadgeListDemo;
import com.flowingcode.vaadin.addons.badgelist.Person;
import com.flowingcode.vaadin.addons.badgelist.TestData;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.combobox.MultiSelectComboBox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.data.binder.ReadOnlyHasValue;
import com.vaadin.flow.data.binder.Setter;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@DemoSource
@PageTitle(value="Read Only Binder Demo")
@Route(value="badge-list/readonly", layout=BadgeListDemoView.class)
public class ReadOnlyBinderDemo
extends BaseBadgeListDemo {
    private TextField firstName = new TextField("First Name");
    private TextField lastName = new TextField("Last Name");
    private MultiSelectComboBox<String> rolesComboBox = new MultiSelectComboBox("Select Roles");
    private BadgeList rolesBadgeList = new BadgeList();
    private ReadOnlyHasValue<List<Badge>> readonlyBadgeList;
    private Div rolesBadgeListDiv = new Div();
    private Button editModeButton = new Button("Edit Mode");
    private Button readOnlyModeButton = new Button("Read Only Mode");
    private Binder<Person> binder;

    public ReadOnlyBinderDemo() {
        Person person = TestData.singlePerson();
        List roles = IntStream.rangeClosed(1, 12).mapToObj(i -> "ROLE" + i).collect(Collectors.toList());
        this.rolesComboBox.setItems(roles);
        this.rolesBadgeList = new BadgeList("Roles");
        this.readonlyBadgeList = new ReadOnlyHasValue(arg_0 -> ((BadgeList)this.rolesBadgeList).setBadges(arg_0));
        this.binder = new Binder();
        this.binder.bind((HasValue)this.firstName, Person::getFirstName, Person::setFirstName);
        this.binder.bind((HasValue)this.lastName, Person::getLastName, Person::setLastName);
        this.readOnlyMode();
        this.binder.setBean((Object)person);
        this.editModeButton.addClickListener((ComponentEventListener & Serializable)e -> this.editMode());
        this.readOnlyModeButton.addClickListener((ComponentEventListener & Serializable)e -> this.readOnlyMode());
        HorizontalLayout buttonsLayout = new HorizontalLayout();
        buttonsLayout.add(new Component[]{this.editModeButton, this.readOnlyModeButton});
        buttonsLayout.setMargin(true);
        buttonsLayout.setJustifyContentMode(FlexComponent.JustifyContentMode.END);
        VerticalLayout layout = new VerticalLayout();
        this.rolesBadgeListDiv.setWidth("450px");
        this.rolesBadgeListDiv.add(new Component[]{this.rolesBadgeList});
        layout.add(new Component[]{this.firstName, this.lastName, this.rolesComboBox, this.rolesBadgeListDiv});
        this.add(new Component[]{layout, buttonsLayout});
    }

    private void editMode() {
        this.editModeButton.setEnabled(false);
        this.readOnlyModeButton.setEnabled(true);
        this.rolesBadgeListDiv.setVisible(false);
        this.binder.removeBinding(this.readonlyBadgeList);
        this.rolesComboBox.setVisible(true);
        this.binder.bind(this.rolesComboBox, (ValueProvider & Serializable)person -> new HashSet<String>(person.getRoles()), (Setter & Serializable)(person, roles) -> person.setRoles(new ArrayList<String>((Collection<String>)roles)));
        this.binder.setReadOnly(false);
    }

    private void readOnlyMode() {
        this.readOnlyModeButton.setEnabled(false);
        this.editModeButton.setEnabled(true);
        this.rolesComboBox.setVisible(false);
        this.binder.removeBinding(this.rolesComboBox);
        this.rolesBadgeListDiv.setVisible(true);
        this.binder.forField(this.readonlyBadgeList).bindReadOnly((ValueProvider & Serializable)person -> person.getRoles().stream().collect(Collectors.mapping(role -> new Badge(role), Collectors.toList())));
        this.binder.setReadOnly(true);
    }
}

