/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.badgelist;

import com.flowingcode.vaadin.addons.badgelist.Badge;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasLabel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.Element;
import java.util.ArrayList;
import java.util.List;

@JsModule.Container(value={@JsModule(value="@vaadin/vaadin-lumo-styles/badge-global.js"), @JsModule(value="./src/fc-badge-list.ts")})
@Tag(value="fc-badge-list")
public class BadgeList
extends Component
implements HasTheme,
HasSize,
HasLabel {
    private List<Badge> badges = new ArrayList<Badge>();

    public BadgeList() {
    }

    public BadgeList(String label) {
        this();
        this.setLabel(label);
    }

    public BadgeList(List<Badge> badges) {
        this.setBadges(badges);
    }

    public void setBadges(List<Badge> badges) {
        this.clearBadges();
        this.badges = badges;
        this.addBadges();
    }

    private void addBadges() {
        this.badges.forEach(badge -> {
            badge.getElement().setAttribute("slot", "badges");
            this.getElement().appendChild(new Element[]{badge.getElement()});
        });
    }

    private void clearBadges() {
        this.badges.forEach(badge -> {
            badge.getElement().removeAttribute("slot");
            badge.removeFromParent();
        });
    }
}

