/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.badgelist;

import com.flowingcode.vaadin.addons.badgelist.Badge;
import com.flowingcode.vaadin.addons.badgelist.BadgeList;
import com.flowingcode.vaadin.addons.badgelist.BadgeListDemoView;
import com.flowingcode.vaadin.addons.badgelist.BaseBadgeListDemo;
import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.demo.SourceCodeViewer;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.util.ArrayList;

@DemoSource
@PageTitle(value="Styled Badges Demo")
@Route(value="badge-list/styled", layout=BadgeListDemoView.class)
public class StyledBadgesDemo
extends BaseBadgeListDemo {
    public StyledBadgesDemo() {
        ArrayList<Badge> badges1 = new ArrayList<Badge>();
        for (int i = 0; i < 8; ++i) {
            Badge badge = new Badge("BADGE" + (i + 1));
            badge.addThemeName("error primary");
            badges1.add(badge);
        }
        BadgeList badgeList1 = new BadgeList(badges1);
        Div layout1 = new Div(new Component[]{badgeList1});
        layout1.setWidth("350px");
        Div example1 = this.createContainerDiv("Badges with 'Error' and 'Primary' variants", (Component)layout1);
        SourceCodeViewer.highlightOnHover((Component)example1, (String)"example1");
        this.add(new Component[]{example1});
        this.addSeparator();
        ArrayList<Badge> badges2 = new ArrayList<Badge>();
        for (int i = 0; i < 12; ++i) {
            Badge badge = new Badge("BADGE" + (i + 1));
            badge.addClassName("custom-styled-badge");
            badges2.add(badge);
        }
        BadgeList badgeList2 = new BadgeList(badges2);
        badgeList2.addClassName("styled-badges-second-example");
        Div layout2 = new Div(new Component[]{badgeList2});
        layout2.setWidth("450px");
        Div example2 = this.createContainerDiv("Badges with custom styling", (Component)layout2);
        SourceCodeViewer.highlightOnHover((Component)example2, (String)"example2");
        this.add(new Component[]{example2});
        this.addSeparator();
        ArrayList<Badge> badges3 = new ArrayList<Badge>();
        for (int i = 0; i < 12; ++i) {
            Badge badge = new Badge(new Component[]{this.createIcon(VaadinIcon.CHECK), new Span("BADGE" + (i + 1))});
            badge.addThemeName("success");
            badges3.add(badge);
        }
        BadgeList badgeList3 = new BadgeList(badges3);
        badgeList3.addThemeName("success");
        Div layout3 = new Div(new Component[]{badgeList3});
        Div example3 = this.createContainerDiv("Badges & Overflow with 'Success' variant and badges with icon", (Component)layout3);
        SourceCodeViewer.highlightOnHover((Component)example3, (String)"example3");
        this.add(new Component[]{example3});
    }

    private Icon createIcon(VaadinIcon vaadinIcon) {
        Icon icon = vaadinIcon.create();
        icon.getStyle().set("padding", "var(--lumo-space-xs");
        return icon;
    }
}

