/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.validation;

import com.flowingcode.backendcore.model.ErrorDescription;
import com.flowingcode.backendcore.validation.ValidationKind;
import com.flowingcode.backendcore.validation.ValidatorBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface Validator<T> {
    public static List<ErrorDescription> success() {
        return Collections.emptyList();
    }

    public List<ErrorDescription> validate(T var1);

    @SafeVarargs
    public static <T> ValidatorBuilder<T> on(ValidationKind ... kinds) {
        return new ValidatorBuilder(kinds);
    }

    public static <T> Validator<T> forCondition(Predicate<T> predicate, Function<T, ErrorDescription> errorSupplier) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(errorSupplier);
        return t -> predicate.test(t) ? Validator.success() : Collections.singletonList((ErrorDescription)errorSupplier.apply(t));
    }
}

