/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.validation;

import com.flowingcode.backendcore.model.ErrorDescription;
import com.flowingcode.backendcore.validation.Validator;
import java.util.List;
import java.util.stream.Collectors;

public interface ValidationSupport<T> {
    public List<Validator<T>> getValidators();

    default public List<Validator<T>> getValidators(Class<? extends Validator> validatorType) {
        return this.getValidators().stream().filter(validatorType::isInstance).collect(Collectors.toList());
    }

    default public List<ErrorDescription> validate(Class<Validator<T>> validatorType, T t) {
        List<Validator<T>> validators = this.getValidators(validatorType);
        return validators.stream().flatMap(val -> val.validate(t).stream()).collect(Collectors.toList());
    }
}

