/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.model;

import com.flowingcode.backendcore.model.Constraint;
import com.flowingcode.backendcore.model.ConstraintTransformerException;
import com.flowingcode.backendcore.model.constraints.AttributeBetweenConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeILikeConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeInConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeLikeConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeNullConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeRelationalConstraint;
import com.flowingcode.backendcore.model.constraints.NegatedConstraint;
import java.util.Optional;
import java.util.function.Function;

public abstract class ConstraintTransformer<T>
implements Function<Constraint, T> {
    @Override
    public final T apply(Constraint c) {
        return Optional.ofNullable(this.transform(c)).orElseThrow(() -> new ConstraintTransformerException("Unsupported constraint: " + c));
    }

    protected T transform(Constraint c) {
        if (c instanceof AttributeBetweenConstraint) {
            return this.transformBetweenConstraint((AttributeBetweenConstraint)c);
        }
        if (c instanceof AttributeLikeConstraint) {
            return this.transformLikeConstraint((AttributeLikeConstraint)c);
        }
        if (c instanceof AttributeRelationalConstraint) {
            return this.transformRelationalConstraint((AttributeRelationalConstraint)c);
        }
        if (c instanceof AttributeInConstraint) {
            return this.transformInConstraint((AttributeInConstraint)c);
        }
        if (c instanceof NegatedConstraint) {
            return this.transformNegatedConstraint((NegatedConstraint)c);
        }
        if (c instanceof AttributeNullConstraint) {
            return this.transformNullConstraint((AttributeNullConstraint)c);
        }
        if (c instanceof AttributeILikeConstraint) {
            return this.transformILikeConstraint((AttributeILikeConstraint)c);
        }
        return null;
    }

    protected T transformRelationalConstraint(AttributeRelationalConstraint c) {
        return null;
    }

    protected T transformLikeConstraint(AttributeLikeConstraint c) {
        return null;
    }

    protected T transformBetweenConstraint(AttributeBetweenConstraint c) {
        return null;
    }

    protected T transformInConstraint(AttributeInConstraint c) {
        return null;
    }

    protected T transformNegatedConstraint(NegatedConstraint c) {
        return null;
    }

    protected T transformNullConstraint(AttributeNullConstraint c) {
        return null;
    }

    protected T transformILikeConstraint(AttributeILikeConstraint c) {
        return null;
    }
}

