/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.model;

import com.flowingcode.backendcore.model.Constraint;
import com.flowingcode.backendcore.model.constraints.AttributeBetweenConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeILikeConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeInConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeLikeConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeNullConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeRelationalConstraint;
import com.flowingcode.backendcore.model.constraints.NegatedConstraint;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;

public class ConstraintBuilder {
    @NonNull
    private final String attribute;

    public static ConstraintBuilder of(String attribute0, String ... attributes) {
        String attribute = Stream.concat(Stream.of(attribute0), Stream.of(attributes)).collect(Collectors.joining("."));
        return new ConstraintBuilder(attribute);
    }

    @Deprecated
    public static Constraint not(Constraint c) {
        return new NegatedConstraint(c);
    }

    @Deprecated
    public static Constraint equal(String attribute, Object value) {
        return new AttributeRelationalConstraint(attribute, value, "=");
    }

    @Deprecated
    public static Constraint notEqual(String attribute, Object value) {
        return new AttributeRelationalConstraint(attribute, value, "<>");
    }

    @Deprecated
    public <T extends Comparable<T>> Constraint between(String attribute, T lower, T upper) {
        return new AttributeBetweenConstraint(attribute, lower, upper);
    }

    @Deprecated
    public static Constraint like(String attribute, String pattern) {
        return new AttributeLikeConstraint(attribute, pattern);
    }

    @Deprecated
    public static Constraint in(String attribute, Collection<?> values) {
        return new AttributeInConstraint(attribute, values);
    }

    @Deprecated
    public static Constraint isNull(String attribute) {
        return new AttributeNullConstraint(attribute);
    }

    @Deprecated
    public static Constraint iLike(String attribute, String pattern) {
        return new AttributeILikeConstraint(attribute, pattern);
    }

    public Constraint equal(Object value) {
        return new AttributeRelationalConstraint(this.attribute, value, "=");
    }

    public Constraint notEqual(Object value) {
        return new AttributeRelationalConstraint(this.attribute, value, "<>");
    }

    public Constraint lessThan(Object value) {
        return new AttributeRelationalConstraint(this.attribute, value, "<");
    }

    public Constraint greaterThan(Object value) {
        return new AttributeRelationalConstraint(this.attribute, value, ">");
    }

    public Constraint greaterOrEqualThan(Object value) {
        return new AttributeRelationalConstraint(this.attribute, value, ">=");
    }

    public Constraint lessOrEqualThan(Object value) {
        return new AttributeRelationalConstraint(this.attribute, value, "<=");
    }

    public <T extends Comparable<T>> Constraint between(T lower, T upper) {
        return new AttributeBetweenConstraint(this.attribute, lower, upper);
    }

    public Constraint like(String pattern) {
        return new AttributeLikeConstraint(this.attribute, pattern);
    }

    public Constraint in(Collection<?> values) {
        return new AttributeInConstraint(this.attribute, values);
    }

    public Constraint isNull() {
        return new AttributeNullConstraint(this.attribute);
    }

    public Constraint isNotNull() {
        return ConstraintBuilder.not(new AttributeNullConstraint(this.attribute));
    }

    public Constraint iLike(String pattern) {
        return new AttributeILikeConstraint(this.attribute, pattern);
    }

    protected ConstraintBuilder(@NonNull String attribute) {
        if (attribute == null) {
            throw new NullPointerException("attribute is marked non-null but is null");
        }
        this.attribute = attribute;
    }
}

