/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.validation;

import com.flowingcode.backendcore.model.ErrorDescription;
import com.flowingcode.backendcore.validation.ValidationKind;
import com.flowingcode.backendcore.validation.Validator;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import lombok.NonNull;

public class ValidatorBuilder<T> {
    @NonNull
    private final ValidationKind[] validationKinds;

    public Validator<T> forCondition(Predicate<T> predicate, Function<T, ErrorDescription> errorSupplier) {
        Validator<T> validator = Validator.forCondition(predicate, errorSupplier);
        Class[] interfaces = (Class[])Stream.of(this.validationKinds).map(ValidationKind::getValidatorType).map(clazz -> clazz.asSubclass(Validator.class)).distinct().toArray(Class[]::new);
        return (Validator)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)new ValidatorDelegate(validator));
    }

    public ValidatorBuilder(@NonNull ValidationKind[] validationKinds) {
        if (validationKinds == null) {
            throw new NullPointerException("validationKinds is marked non-null but is null");
        }
        this.validationKinds = validationKinds;
    }

    private static final class ValidatorDelegate
    implements InvocationHandler,
    Serializable {
        final Validator<?> delegate;

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return method.invoke(this.delegate, args);
        }

        public ValidatorDelegate(Validator<?> delegate) {
            this.delegate = delegate;
        }
    }
}

