/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.model;

import java.io.Serializable;
import java.util.Objects;

public abstract class BaseMessage
implements Serializable {
    protected static final String FIELD_CANNOT_BE_NULL = "field cannot be null";
    protected static final String MESSAGE_KEY_CANNOT_BE_NULL = "messageKey cannot be null";
    private static final long serialVersionUID = 1L;
    private String field;
    private String messageKey;
    private Serializable[] messageKeyValues;

    protected BaseMessage(String messageKey) {
        Objects.requireNonNull(messageKey, MESSAGE_KEY_CANNOT_BE_NULL);
        this.messageKey = messageKey;
    }

    protected BaseMessage(String messageKey, Serializable[] messageKeyValues) {
        Objects.requireNonNull(messageKey, MESSAGE_KEY_CANNOT_BE_NULL);
        this.messageKey = messageKey;
        this.messageKeyValues = messageKeyValues;
    }

    protected BaseMessage(String field, String messageKey, Serializable ... messageKeyValues) {
        Objects.requireNonNull(field, FIELD_CANNOT_BE_NULL);
        Objects.requireNonNull(messageKey, MESSAGE_KEY_CANNOT_BE_NULL);
        this.field = field;
        this.messageKey = messageKey;
        this.messageKeyValues = messageKeyValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.messageKey == null ? 0 : this.messageKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BaseMessage)) {
            return false;
        }
        BaseMessage other = (BaseMessage)obj;
        return !(this.messageKey == null ? other.messageKey != null : !this.messageKey.equals(other.messageKey));
    }

    public String getField() {
        return this.field;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public Serializable[] getMessageKeyValues() {
        return this.messageKeyValues;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public void setMessageKeyValues(Serializable[] messageKeyValues) {
        this.messageKeyValues = messageKeyValues;
    }
}

