/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.exception;

import com.flowingcode.backendcore.model.ErrorDescription;
import java.io.Serializable;
import java.util.List;

public abstract class BaseException
extends RuntimeException {
    private static final String DEFAULT_MESSAGE_KEY = "errors.service.default";
    private static final long serialVersionUID = 1L;
    private final String messageKey;
    private final Serializable[] messageKeyValues;
    private List<ErrorDescription> errors;

    public BaseException() {
        this.messageKey = DEFAULT_MESSAGE_KEY;
        this.messageKeyValues = null;
    }

    public BaseException(Throwable cause) {
        super(cause);
        this.messageKey = DEFAULT_MESSAGE_KEY;
        this.messageKeyValues = null;
    }

    public BaseException(String messageKey) {
        super(messageKey);
        this.messageKey = messageKey;
        this.messageKeyValues = null;
    }

    public BaseException(Throwable cause, String messageKey, Serializable ... messageKeyValues) {
        super(cause);
        this.messageKey = messageKey;
        this.messageKeyValues = messageKeyValues;
    }

    public BaseException(String messageKey, Serializable ... messageKeyValues) {
        super(messageKey);
        this.messageKey = messageKey;
        this.messageKeyValues = messageKeyValues;
    }

    public BaseException(Throwable cause, ErrorDescription error) {
        super(error.getMessageKey(), cause);
        this.messageKey = error.getMessageKey();
        this.messageKeyValues = error.getMessageKeyValues();
    }

    public BaseException(Throwable cause, List<ErrorDescription> errors) {
        super(cause);
        this.errors = errors;
        this.messageKey = DEFAULT_MESSAGE_KEY;
        this.messageKeyValues = null;
        this.fillSuppressed();
    }

    public BaseException(List<ErrorDescription> errors) {
        this.errors = errors;
        this.messageKey = DEFAULT_MESSAGE_KEY;
        this.messageKeyValues = null;
        this.fillSuppressed();
    }

    private void fillSuppressed() {
        if (this.errors != null) {
            for (ErrorDescription error : this.errors) {
                BaseException e = this.newInstance(error);
                e.setStackTrace(new StackTraceElement[0]);
                this.addSuppressed(e);
            }
        }
    }

    protected abstract BaseException newInstance(ErrorDescription var1);

    public Object[] getMessageKeyValues() {
        return this.messageKeyValues;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public List<ErrorDescription> getErrors() {
        return this.errors;
    }

    public <T extends ErrorDescription> void addError(T error) {
        if (error != null) {
            this.errors.add(error);
        }
    }
}

