/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.model;

import com.flowingcode.backendcore.model.Constraint;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class QuerySpec {
    private String[] returnedAttributes;
    private Map<String, Order> orders;
    private Integer firstResult;
    private Integer maxResult;
    private final Collection<Constraint> constraints = new ArrayList<Constraint>();

    public void addOrder(String property, Order order) {
        if (this.orders == null) {
            this.orders = new LinkedHashMap<String, Order>();
        }
        this.orders.put(property, order);
    }

    public void addOrder(String property) {
        this.addOrder(property, Order.ASC);
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getName());
        try {
            buffer.append("{ ");
            BeanInfo info = Introspector.getBeanInfo(this.getClass(), Object.class);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                String value = String.valueOf(pd.getReadMethod() != null ? pd.getReadMethod().invoke((Object)this, new Object[0]) : "?");
                buffer.append(" [" + pd.getName() + "=" + value + "]");
            }
            buffer.append(" }");
        }
        catch (Exception e) {
            buffer.append("Error: " + e.getMessage());
        }
        return buffer.toString();
    }

    public Integer getFirstResult() {
        return this.firstResult;
    }

    public Integer getMaxResult() {
        return this.maxResult;
    }

    public void setFirstResult(Integer firstResult) {
        if (firstResult != null && firstResult < 0) {
            throw new IllegalArgumentException();
        }
        this.firstResult = firstResult;
    }

    public void setMaxResult(Integer maxResult) {
        if (maxResult != null && maxResult < 0) {
            throw new IllegalArgumentException();
        }
        this.maxResult = maxResult;
    }

    public String[] getReturnedAttributes() {
        return this.returnedAttributes;
    }

    public void setReturnedAttributes(String[] returnedAttributes) {
        this.returnedAttributes = returnedAttributes;
    }

    public Map<String, Order> getOrders() {
        return this.orders;
    }

    public void setOrders(Map<String, Order> orders) {
        this.orders = orders;
    }

    public Collection<Constraint> getConstraints() {
        return this.constraints;
    }

    public static enum Order {
        ASC,
        DESC;

    }
}

