/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.dao.jpa;

import com.flowingcode.backendcore.model.ConstraintTransformer;
import com.flowingcode.backendcore.model.constraints.AttributeBetweenConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeILikeConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeInConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeLikeConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeNullConstraint;
import com.flowingcode.backendcore.model.constraints.AttributeRelationalConstraint;
import com.flowingcode.backendcore.model.constraints.NegatedConstraint;
import jakarta.persistence.EntityManager;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;

public class ConstraintTransformerJpaImpl
extends ConstraintTransformer<Predicate> {
    @NonNull
    private final CriteriaBuilder criteriaBuilder;
    @NonNull
    private final From<?, ?> root;

    public ConstraintTransformerJpaImpl(EntityManager em, From<?, ?> root) {
        this.criteriaBuilder = em.getCriteriaBuilder();
        this.root = Objects.requireNonNull(root);
    }

    private Expression<?> getExpression(AttributeConstraint c) {
        return this.getExpression(c, Object.class);
    }

    private <T> Expression<T> getExpression(AttributeConstraint c, Class<T> type) {
        String[] path = c.getAttribute().split("\\.");
        String attributeName = path[path.length - 1];
        path = Arrays.copyOf(path, path.length - 1);
        Path expression = this.join(this.root, path).get(attributeName);
        ConstraintTransformerJpaImpl.boxed(expression.getJavaType()).asSubclass(type);
        return expression;
    }

    private From<?, ?> join(From<?, ?> root, String[] path) {
        From<?, ?> from = root;
        for (String attributeName : path) {
            from = this.join(from, attributeName);
        }
        return from;
    }

    private From<?, ?> join(From<?, ?> source, String attributeName) {
        Optional<Join> existingJoin = source.getJoins().stream().filter(join -> join.getAttribute().getName().equals(attributeName)).map(join -> join).findFirst();
        return (From)existingJoin.orElseGet(() -> source.join(attributeName, JoinType.INNER));
    }

    private static Class<?> boxed(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
        }
        return type;
    }

    protected Predicate transformNegatedConstraint(NegatedConstraint c) {
        return this.criteriaBuilder.not((Expression)this.transform(c.getConstraint()));
    }

    protected Predicate transformRelationalConstraint(AttributeRelationalConstraint c) {
        switch (c.getOperator()) {
            case "=": 
            case "<>": {
                return this.transformEqualityConstraint(c);
            }
        }
        return this.transformComparisonConstraint(c);
    }

    private Predicate transformEqualityConstraint(AttributeRelationalConstraint c) {
        Expression<?> x = this.getExpression((AttributeConstraint)c);
        Object y = c.getValue();
        switch (c.getOperator()) {
            case "=": {
                return this.criteriaBuilder.equal(x, y);
            }
            case "<>": {
                return this.criteriaBuilder.notEqual(x, y);
            }
        }
        return null;
    }

    private Predicate transformComparisonConstraint(AttributeRelationalConstraint c) {
        Expression<Comparable> x = this.getExpression((AttributeConstraint)c, Comparable.class);
        Comparable y = (Comparable)c.getValue();
        switch (c.getOperator()) {
            case "<=": {
                return this.criteriaBuilder.lessThanOrEqualTo(x, y);
            }
            case "<": {
                return this.criteriaBuilder.lessThan(x, y);
            }
            case ">=": {
                return this.criteriaBuilder.greaterThanOrEqualTo(x, y);
            }
            case ">": {
                return this.criteriaBuilder.greaterThan(x, y);
            }
        }
        return null;
    }

    protected Predicate transformLikeConstraint(AttributeLikeConstraint c) {
        return this.criteriaBuilder.like(this.getExpression((AttributeConstraint)c, String.class), c.getPattern());
    }

    protected Predicate transformBetweenConstraint(AttributeBetweenConstraint c) {
        return this.criteriaBuilder.between(this.getExpression((AttributeConstraint)c, Comparable.class), c.getLower(), c.getUpper());
    }

    protected Predicate transformInConstraint(AttributeInConstraint c) {
        return this.getExpression((AttributeConstraint)c).in(c.getValues());
    }

    protected Predicate transformNullConstraint(AttributeNullConstraint c) {
        return this.getExpression((AttributeConstraint)c).isNull();
    }

    protected Predicate transformILikeConstraint(AttributeILikeConstraint c) {
        return this.criteriaBuilder.like(this.criteriaBuilder.lower(this.getExpression((AttributeConstraint)c, String.class)), c.getPattern().toLowerCase());
    }

    public ConstraintTransformerJpaImpl(@NonNull CriteriaBuilder criteriaBuilder, @NonNull From<?, ?> root) {
        if (criteriaBuilder == null) {
            throw new NullPointerException("criteriaBuilder is marked non-null but is null");
        }
        if (root == null) {
            throw new NullPointerException("root is marked non-null but is null");
        }
        this.criteriaBuilder = criteriaBuilder;
        this.root = root;
    }
}

