/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.dao.jpa;

import com.flowingcode.backendcore.dao.CrudDao;
import com.flowingcode.backendcore.dao.jpa.ConstraintTransformerJpaImpl;
import com.flowingcode.backendcore.dao.jpa.JpaDaoSupport;
import com.flowingcode.backendcore.model.Identifiable;
import com.flowingcode.backendcore.model.QuerySpec;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public interface ConversionJpaDaoSupport<S, T extends Identifiable<K>, K extends Serializable>
extends CrudDao<S, K> {
    public EntityManager getEntityManager();

    public T convertTo(S var1);

    public S convertFrom(T var1);

    default public Class<T> getPersistentClass() {
        Type[] interfaces;
        for (Type type : interfaces = this.getClass().getGenericInterfaces()) {
            if (!(type instanceof ParameterizedType)) continue;
            ParameterizedType ptype = (ParameterizedType)type;
            if (ptype.getRawType().equals(ConversionJpaDaoSupport.class)) {
                return (Class)ptype.getActualTypeArguments()[1];
            }
            if (!ptype.getRawType().equals(JpaDaoSupport.class)) continue;
            return (Class)ptype.getActualTypeArguments()[0];
        }
        throw new UnsupportedOperationException("Couldn't find entity type, probably " + ConversionJpaDaoSupport.class + " is not being implemented, try overriding this method");
    }

    default public K save(S entity) {
        Object persistentEntity = this.convertTo(entity);
        persistentEntity = (Identifiable)this.getEntityManager().merge(persistentEntity);
        Serializable id = (Serializable)persistentEntity.getId();
        return (K)Objects.requireNonNull(id, "id");
    }

    default public void update(S entity) {
        T persistentEntity = this.convertTo(entity);
        Objects.requireNonNull((Serializable)persistentEntity.getId(), "id");
        this.getEntityManager().merge(persistentEntity);
    }

    default public void delete(S entity) {
        Object persistentEntity = this.convertTo(entity);
        EntityManager em = this.getEntityManager();
        persistentEntity = (Identifiable)em.getReference(this.getPersistentClass(), persistentEntity.getId());
        em.remove(persistentEntity);
    }

    default public Optional<S> findById(K id) {
        return FilterProcesor.of(this.getEntityManager(), this.getPersistentClass()).findById(id).map(this::convertFrom);
    }

    default public List<S> findAll() {
        return FilterProcesor.of(this.getEntityManager(), this.getPersistentClass()).findAll().stream().map(this::convertFrom).collect(Collectors.toList());
    }

    default public long count(QuerySpec filter) {
        return FilterProcesor.of(this.getEntityManager(), this.getPersistentClass()).count(filter);
    }

    default public List<S> filter(QuerySpec filter) {
        return FilterProcesor.of(this.getEntityManager(), this.getPersistentClass()).filter(filter).stream().map(this::convertFrom).collect(Collectors.toList());
    }

    default public Optional<S> filterWithSingleResult(QuerySpec filter) {
        List<T> filtered = FilterProcesor.of(this.getEntityManager(), this.getPersistentClass()).filter(filter);
        if (filtered.size() > 1) {
            throw new IllegalStateException("Current filter returned more than one result");
        }
        return filtered.stream().map(this::convertFrom).findAny();
    }

    public static class FilterProcesor<T extends Identifiable<K>, K extends Serializable> {
        private Class<T> persistentClass;
        private EntityManager entityManager;

        private static <T extends Identifiable<K>, K extends Serializable> FilterProcesor<T, K> of(EntityManager entityManager, Class<T> persistentClass) {
            return new FilterProcesor<T, K>(entityManager, persistentClass);
        }

        long count(QuerySpec filter) {
            CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(Long.class);
            Root root = cq.from(this.persistentClass);
            cq.select((Selection)cb.count((Expression)root));
            this.addWhere(filter, cb, cq, root);
            return (Long)this.entityManager.createQuery(cq).getSingleResult();
        }

        List<T> findAll() {
            CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
            CriteriaQuery cq = cb.createQuery(this.persistentClass);
            Root rootEntry = cq.from(this.persistentClass);
            CriteriaQuery all = cq.select((Selection)rootEntry);
            TypedQuery allQuery = this.entityManager.createQuery(all);
            return allQuery.getResultList();
        }

        Optional<T> findById(K id) {
            return Optional.ofNullable((Identifiable)this.entityManager.find(this.persistentClass, id));
        }

        private FilterProcesor(EntityManager entityManager, Class<T> persistentClass) {
            this.entityManager = entityManager;
            this.persistentClass = persistentClass;
        }

        public List<T> filter(QuerySpec baseFilter) {
            if (baseFilter.getReturnedAttributes() != null && baseFilter.getReturnedAttributes().length > 0) {
                return this.filterNotFullData(baseFilter);
            }
            return this.filterFullData(baseFilter);
        }

        protected CriteriaQuery<T> createFilterCriteria(QuerySpec baseFilter, CriteriaBuilder cb) {
            CriteriaQuery crit = cb.createQuery(this.persistentClass);
            Root root = crit.from(this.persistentClass);
            crit = this.addWhere(baseFilter, cb, crit, root);
            if (baseFilter.getOrders() != null) {
                for (Map.Entry entry : baseFilter.getOrders().entrySet()) {
                    if (QuerySpec.Order.ASC.equals(entry.getValue())) {
                        crit.orderBy(new Order[]{cb.asc((Expression)root.get((String)entry.getKey()))});
                        continue;
                    }
                    crit.orderBy(new Order[]{cb.desc((Expression)root.get((String)entry.getKey()))});
                }
            }
            return crit;
        }

        private <U> CriteriaQuery<U> addWhere(QuerySpec baseFilter, CriteriaBuilder cb, CriteriaQuery<U> cq, Root<T> root) {
            if (!baseFilter.getConstraints().isEmpty()) {
                return cq.where((Predicate[])baseFilter.getConstraints().stream().map(new ConstraintTransformerJpaImpl(this.entityManager, (From<?, ?>)root)).toArray(Predicate[]::new));
            }
            return cq;
        }

        protected List<T> filterFullData(QuerySpec filter) {
            CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
            CriteriaQuery<T> criteria = this.createFilterCriteria(filter, cb);
            return this.addPagination(criteria, filter).getResultList();
        }

        protected List<T> filterNotFullData(QuerySpec filter) {
            CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
            CriteriaQuery<T> criteria = this.createFilterCriteria(filter, cb);
            return this.addPagination(criteria, filter).getResultList();
        }

        protected List<T> executeCriteria(CriteriaQuery<T> criteria) {
            return this.entityManager.createQuery(criteria).getResultList();
        }

        protected T executeCriteriaForUniqueResult(CriteriaQuery<T> criteria) {
            return (T)((Identifiable)this.entityManager.createQuery(criteria).getSingleResult());
        }

        protected TypedQuery<T> addPagination(CriteriaQuery<T> detachedCriteria, QuerySpec filter) {
            TypedQuery criteria = this.entityManager.createQuery(detachedCriteria);
            if (filter.getFirstResult() != null) {
                criteria.setFirstResult(filter.getFirstResult().intValue());
            }
            if (filter.getMaxResult() != null) {
                criteria.setMaxResults(filter.getMaxResult().intValue());
            }
            return criteria;
        }
    }
}

