/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.service;

import com.flowingcode.backendcore.dao.jpa.ConstraintTransformerJpaImpl;
import com.flowingcode.backendcore.model.Constraint;
import com.flowingcode.backendcore.model.QuerySpec;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.lang.NonNull;

final class ConstraintSpecification<T>
implements Specification<T> {
    @NonNull
    private final Constraint constraint;

    private static <T> Specification<T> newInstance(Constraint constraint) {
        return new ConstraintSpecification<T>(constraint);
    }

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        return (Predicate)new ConstraintTransformerJpaImpl(criteriaBuilder, root).apply(this.constraint);
    }

    static <T> Specification<T> buildSpecification(QuerySpec querySpec) {
        return querySpec.getConstraints().stream().map(ConstraintSpecification::newInstance).reduce(Specification::and).orElse(null);
    }

    private ConstraintSpecification(@NonNull Constraint constraint) {
        if (constraint == null) {
            throw new NullPointerException("constraint is marked non-null but is null");
        }
        this.constraint = constraint;
    }
}

